#define  HOLE_SOURCE_C_C
#include "hole-util.h"

int Create_Holes(CONTROL_INFO *controlInfo, 
		 FILTERBANK *ffamily,
		 IMAGE_DATABASE *adatabase,
		 IMAGEINT *animage,
		 DIGGED_HOLES *digged,
		 int redigged_flag)
{
  int i,j,k;
  int overlapped;
  int crow, ccol;
  int triesTimes;
  char fname[256];
  int max_overlaps;
  ffamily->max_ht *= 2;
  ffamily->max_wid *= 2;
  
  if (redigged_flag ==0) {
    digged->hole_size = controlInfo->hole_size;
    if (digged->nhole > 0) {
      Free_Holes(digged);
    }
    if (controlInfo->holes_regular >0) {
      digged->nhole =0;
      for (i=ffamily->max_ht +
	     (controlInfo->holes_regular-controlInfo->hole_size)/2;
	   i < animage->nrow - ffamily->max_ht -
	     (controlInfo->holes_regular+controlInfo->hole_size)/2;
	   i += controlInfo->holes_regular ) {
	for (j=ffamily->max_wid +
	       (controlInfo->holes_regular-controlInfo->hole_size)/2;
	     j < animage->ncol - ffamily->max_wid -
	       (controlInfo->holes_regular+controlInfo->hole_size)/2;
	     j += controlInfo->holes_regular ) {
	  if ( (i >= ffamily->max_ht) &&
	       ((i+controlInfo->hole_size)<=(animage->nrow-ffamily->max_ht)) &&
	       (j >= ffamily->max_wid) &&
	       ((j+controlInfo->hole_size)<=
		(animage->ncol-ffamily->max_wid))) {
	    digged->nhole++;
	  }
	}
      }
    }
    else {
      digged->nhole = controlInfo->num_of_holes;
    }
    digged->hole_map.nrow = 0;
    digged->holes = (ONE_HOLE *)malloc(sizeof(ONE_HOLE)*digged->nhole);
    if (digged->holes == NULL) {
      fprintf(stderr,"Cannot create %d holes.\n",digged->nhole);
      exit(-1);
    }
    digged->saved_lambdas = Create_Array(ffamily->totalBin);
  
    digged->saved_hole_patch.nrow = 0;
    Create_An_Image_Int(digged->hole_size, digged->hole_size,
			&(digged->saved_hole_patch));
    digged->saved_filter_map.nrow = 0;
    Create_An_Image_Vector(ffamily->nfilter,
			   digged->hole_size+2*ffamily->max_ht,
			   digged->hole_size+2*ffamily->max_wid,
			   &(digged->saved_filter_map));
    digged->num_samples = controlInfo->hole_total_syn+1;
    
    /* Additional hole information */
    digged->patch_hist.nrow = 0;
    if (controlInfo->holes_need_patch_hist) {
      Create_An_Image_Float(ffamily->greyLevel, ffamily->totalBin,
			    &(digged->patch_hist));
    }
    for (k=0; k < digged->nhole; k++) {
      digged->holes[k].hole_size = digged->hole_size;
      digged->holes[k].num_ref_model = adatabase->num_ref_model;
      digged->holes[k].num_samples = digged->num_samples;
      digged->holes[k].totalBin = ffamily->totalBin;
      digged->holes[k].hist.nrow = 0;
      /* Create the histogram vector for each hole in the 
	 satellite case only */
      if (controlInfo->holes_need_hist_vector) {
	Create_An_Image_Vector(digged->holes[k].num_ref_model,
			       (int)(digged->holes[k].num_samples),
			       ffamily->totalBin,
			       &(digged->holes[k].hist));
      }
    }
    
    digged->hole_map.nrow = 0;
    Create_An_Image_Int(animage->nrow,animage->ncol,
			&(digged->hole_map));
  }
  for (i=0; i < animage->nrow; i++) {
    for (j=0; j < animage->ncol; j++) {
      digged->hole_map.data[i][j] = 0;
    }
  }
  max_overlaps = 0;
  if (controlInfo->holes_regular >0) {
    k = 0;
    for (i=ffamily->max_ht +
	   (controlInfo->holes_regular-controlInfo->hole_size)/2;
	 i < animage->nrow - ffamily->max_ht -
	   (controlInfo->holes_regular+controlInfo->hole_size)/2;
	 i += controlInfo->holes_regular ) {
      for (j=ffamily->max_wid +
	     (controlInfo->holes_regular-controlInfo->hole_size)/2;
	   j < animage->ncol - ffamily->max_wid -
	     (controlInfo->holes_regular+controlInfo->hole_size)/2;
	   j += controlInfo->holes_regular ) {
	if ( (i >= ffamily->max_ht) &&
	     ((i+controlInfo->hole_size)<= (animage->nrow-ffamily->max_ht)) &&
	     (j >= ffamily->max_wid) &&
	     ((j+controlInfo->hole_size)<=(animage->ncol-ffamily->max_wid))) {
	  digged->holes[k].row = i;
	  digged->holes[k].col = j;
	  for (crow = i; crow < (i+digged->hole_size); crow++) {
	    for (ccol = j; ccol < (j+digged->hole_size); ccol++) {
	      digged->hole_map.data[crow][ccol] ++;
	      if (max_overlaps < digged->hole_map.data[crow][ccol])
		max_overlaps = digged->hole_map.data[crow][ccol];
	    }
	  }
	  k++;
	}
      }
    }
    if (k != digged->nhole) {
      fprintf(stderr,"Error: Digged %d regular holes, which is different ",
	      k);
      fprintf(stderr,"%d.\n", digged->nhole);
      exit(-1);
    }
  }
  else {
    for (k=0; k < digged->nhole; k++) {
      triesTimes = 0;
      do {
	i = (int)(Unit_Random() * (animage->nrow - 2*ffamily->max_ht
				   - 1 - digged->hole_size)) +
	  ffamily->max_ht;
	j = (int)(Unit_Random() * (animage->ncol -2*ffamily->max_wid
				   - 1- digged->hole_size)) +
	  ffamily->max_wid;
	if (controlInfo->overlapped_holes) break;
	overlapped = 0;
	for (crow = i; crow < (i+digged->hole_size); crow++) {
	  for (ccol = j; ccol < (j+digged->hole_size); ccol++) {
	    if (digged->hole_map.data[crow][ccol] >0) {
	      overlapped++;
	      break;
	    }
	  }
	  if (overlapped) break;
	}
	triesTimes++;
	if (triesTimes > (animage->nrow*animage->ncol)) {
	  fprintf(stderr,"Can create only %d ",
		  k);
	  fprintf(stderr,"nonoverlapped holes with size %d\n",
		  digged->hole_size);
	  fprintf(stderr,"This time I have tried %d times and ",triesTimes);
	  fprintf(stderr,"still does not work and so I gave it up.\n");
	  
	  fprintf(stderr,"WARNING: Switch automatically to ");
	  fprintf(stderr,"overlapping mode.\n");
	  controlInfo->overlapped_holes =1;
	}
      } while(overlapped);
      
      digged->holes[k].row = i;
      digged->holes[k].col = j;
    
      for (crow = i; crow < (i+digged->hole_size); crow++) {
	for (ccol = j; ccol < (j+digged->hole_size); ccol++) {
	  digged->hole_map.data[crow][ccol] ++;
	  if (max_overlaps < digged->hole_map.data[crow][ccol])
	    max_overlaps = digged->hole_map.data[crow][ccol];
	}
      }
    }
  }
  if (redigged_flag ==0) {
    ffamily->norm = 0.0;
    for (i=0; i < digged->hole_map.nrow; i++) {
      for (j=0; j < digged->hole_map.ncol; j++) {
	ffamily->norm += (float)digged->hole_map.data[i][j];
      }
    }
  }
  sprintf(fname,"%s_digged_hole.pgm", controlInfo->prefix);
  Write_An_Image_Int(&(digged->hole_map), 
		     (int)(256/max_overlaps), fname);
  
   ffamily->max_ht /= 2;
  ffamily->max_wid /= 2;
  return digged->nhole;
}

void Free_Holes(DIGGED_HOLES *digged)
{
  int i;
  if (digged->nhole > 0) {
    for (i=0; i < digged->nhole; i++) 
      Free_Image_Vector(&(digged->holes[i].hist));
    free(digged->holes);
    Free_Image_Int(&(digged->hole_map));
    Free_Image_Int(&(digged->saved_hole_patch));
    Free_Image_Float(&(digged->patch_hist));
    Free_Image_Vector(&(digged->saved_filter_map));
    Free_Array(digged->saved_lambdas);
    digged->nhole = 0;
  }
}



void Update_Hole_Pixel(FILTERBANK *ffamily,
		       IMAGEINT *syn,
		       int row, int col, int val)
{
  ARRAY  kernel;
  MAT    map;
  FILTER *filter;
  int  filter_no;   
  float diff;
  int   i,old, mid, *pr, *pc;
  
  old=syn->data[row][col];
  if (old == val) return;
  diff=(val-old);
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    map=filter->map.data;
    kernel=filter->kernel;
    mid=filter->size-1;
    /* without checking the boundary to save time */
    pr=filter->rlist; pc=filter->clist; 
    for(i=0; i<filter->size; i++) { 
      map[row+ *pr][col+ *pc] += diff*kernel[mid-i]; pr++; pc++;
    }
  }
  syn->data[row][col] = val;
  return;
} 

void Compute_Hole_Hist_Into_Vector(FILTERBANK *ffamily,
				   DIGGED_HOLES *holefamily,
				   ONE_HOLE *ahole,
				   float *hist_vect)
{
  int i, j;
  int crow, ccol;
  FILTER *filter;
  int  filter_no; 
  int index;
  /* Clean the histogram vector */
  for (i=0; i < ffamily->totalBin; i++) {
    hist_vect[i] = 0.0;
  }
  /* Compute the histograms with the boundary conditions */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      crow = ahole->row+i;
      ccol = ahole->col+j;
      for(filter_no=0; filter_no<ffamily->nfilter; filter_no++)  {
	filter= &(ffamily->fbank[filter_no]);
	index = Round((filter->map.data[crow][ccol]-filter->mark[0])
		      /(filter->unit));
	if (index < 0) index =0;
	else {
	  if (index >= (filter->bin_num)) 
	    index = filter->bin_num-1;
	}
	hist_vect[ffamily->filterDim[filter_no]+index] +=1;
      }
    }
  }
  return;
}

void Compute_Hole_Hist_Into_Vector_With_Bound(FILTERBANK *ffamily,
					      DIGGED_HOLES *holefamily,
					      ONE_HOLE *ahole,
					      float *hist_vect)
{
  int i, j;
  int crow, ccol;
  FILTER *filter;
  int  filter_no; 
  int index;
  /* Clean the histogram vector */
  for (i=0; i < ffamily->totalBin; i++) {
    hist_vect[i] = 0.0;
  }
  /* Compute the histograms with the boundary conditions */
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0-filter->ht; i < holefamily->hole_size+filter->ht; i++) {
      for (j=0-filter->wid; j < holefamily->hole_size+filter->wid; j++) {
	crow = ahole->row+i;
	ccol = ahole->col+j;
	index = Round((filter->map.data[crow][ccol]-filter->mark[0])
		      /(filter->unit));
	if (index < 0) index =0;
	else {
	  if (index >= (filter->bin_num)) 
	    index = filter->bin_num-1;
	}
	hist_vect[ffamily->filterDim[filter_no]+index] +=1;
      }
    }
  }
  return;
}


void Compute_Hole_Pseudo_Hist_Into_Vector(FILTERBANK *ffamily,
					  DIGGED_HOLES *holefamily,
					  ONE_HOLE *ahole,
					  float *hist_vect)
{
  int i, j, k;
  int crow, ccol;
  FILTER *filter;
  int  filter_no; 
  int index;
  int  *pr, *pc;
  /* Clean the histogram vector */
  for (i=0; i < ffamily->totalBin; i++) {
    hist_vect[i] = 0.0;
  }
  /* Compute the histograms with the boundary conditions */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      crow = ahole->row+i;
      ccol = ahole->col+j;
      for(filter_no=0; filter_no<ffamily->nfilter; filter_no++)  {
	filter= &(ffamily->fbank[filter_no]);
	
	pr=filter->rlist; pc=filter->clist; 
	for(i=0; i<filter->size; i++) { 
	  index = 
	    Round((filter->map.data[crow+ (*pr)][ccol+(*pc)]-
		   filter->mark[0])
		  / (filter->unit));
	  pr++; pc++;
	  if (index < 0) index =0;
	  else {
	    if (index >= (filter->bin_num)) 
	      index = filter->bin_num-1;
	  }
	  hist_vect[ffamily->filterDim[filter_no]+index] +=1;
	}
      }
    }
  }
  return;
}


void Accumalate_Hole_Local_Hist(FILTERBANK *ffamily,
				DIGGED_HOLES *holefamily,
				ONE_HOLE *ahole)
{
  int i, j;
  int crow, ccol;
  FILTER *filter;
  int  filter_no; 
  int index;
  
  /* Compute the histograms with the boundary conditions */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      crow = ahole->row+i;
      ccol = ahole->col+j;
      for(filter_no=0; filter_no<ffamily->nfilter; filter_no++)  {
	filter= &(ffamily->fbank[filter_no]);
	index = Round((filter->map.data[crow][ccol]-filter->mark[0])
		      /(filter->unit));
	if (index < 0) index =0;
	else {
	  if (index >= (filter->bin_num)) 
	    index = filter->bin_num-1;
	}
	filter->hist[index] +=1;
      }
    }
  }
  return;
}

/* Generate samples from the synthesized images without sampling */
int Pick_From_Synthesized_Image(CONTROL_INFO *controlInfo,
				FILTERBANK *ffamily,
				DIGGED_HOLES *holefamily,
				ONE_HOLE *ahole,
				int cur_hole,
				int now_model,
				ONE_IMAGE_ENTRY *amodel,
				IMAGEINT *syn,
				int  now_samples)
{
  IMAGEINT synthesized_img;
  int k;
  int syn_i, syn_j;
  int i,j, val;
  char fname[256];

  synthesized_img.nrow = 0;
  
  if (Read_An_Obs_Image(amodel->synImage, &synthesized_img,
			controlInfo) != 0) {
    fprintf(stderr, "Cannot read the %dth model synthesized image ",
	    now_model);
    fprintf(stderr, "from image \n\t%s.\n", amodel->synImage);
    return now_samples;
  }
  
  for (k = strlen(amodel->synImage)-1; k>=0; k--) {
    if (amodel->synImage[k] == '/') 
      break;
  }
  k++;
  printf("Picking up %d samples randomly from %s.\n",
	 (ahole->num_samples-now_samples),
	 &(amodel->synImage[k]));
      
  for (k=now_samples; k < ahole->num_samples; k++) {
    do {
      syn_i = (int)(Unit_Random()*(synthesized_img.nrow - 
				   holefamily->hole_size-1));
      syn_j = (int)(Unit_Random()*(synthesized_img.ncol -
				   holefamily->hole_size-1));
    } while ( ( (syn_i+holefamily->hole_size) > synthesized_img.nrow) ||
	      ( (syn_j+holefamily->hole_size) > synthesized_img.ncol) );
    
    for (i=0; i < holefamily->hole_size; i++) {
      for (j=0; j < holefamily->hole_size; j++) {
	val = synthesized_img.data[syn_i+i][syn_j+j];
	if (val >= ffamily->greyLevel) {
	  printf("Value %d from %s is out of range at pixel (%d,%d).\n",
		 val,
		 amodel->synImage, syn_j+j, syn_i+i);
	  val = ffamily->greyLevel - 1;
	}
	Update_Hole_Pixel(ffamily, syn, (int)(i+ahole->row), 
			  (int)(j+ahole->col), 
			  (int)val);
	
      }
    }
    /*
      sprintf(fname, "%s_%d_%d_%d.pgm",
      controlInfo->prefix, cur_hole, now_model, k);
      Write_An_Image_Int(syn, (int)(256/ffamily->greyLevel), fname);
    */
    Compute_Hole_Hist_Into_Vector(ffamily,
				  holefamily,
				  ahole,
				  ahole->hist.data[now_model][k]);
  }
  Free_Image_Int(&synthesized_img);
  return k;
}
    
     

void Generate_Hole_All_Model(CONTROL_INFO *controlInfo, 
			     FILTERBANK *ffamily,
			     IMAGE_DATABASE *adatabase,
			     DIGGED_HOLES *holefamily,
			     ONE_HOLE *ahole,
			     int cur_hole,
			     IMAGEINT *syn)
{
  int i, j,k, filter_no;
  int k1, k2, iter;
  int crow, ccol;
  float least, sum, r;
  int val;
  FILTER *filter;
  int index;
  int row, col;
  float *energy;
  float *prob;
  ONE_IMAGE_ENTRY *amodel;
  int now_model;
  int now_samples;
  int save_hole_syn_init_iter;
  char fname[256];
  energy = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  prob = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  
  row = ahole->row;
  col = ahole->col;
  /* Save the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      holefamily->saved_hole_patch.data[i][j] = 
	syn->data[i+row][j+col];
    }
  }
  /* Save the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	holefamily->saved_filter_map.data[filter_no][k1][k2] = 
	  filter->map.data[i][j];
      }
    }
  }
  /* Save the current lambda's */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
      holefamily->saved_lambdas[ffamily->filterDim[filter_no]+i]
	= filter->lambda[i];
    }
  }

  now_samples = 0;
  /* For all the reference models, the first patch is always the 
     observed patch in order to upbound the local 
     likelihood function 
  */
  if (controlInfo->include_observed) {
    for (now_model =0; now_model < adatabase->num_ref_model; now_model++) {
      Compute_Hole_Hist_Into_Vector(ffamily,
				    holefamily,
				    ahole,
				    ahole->hist.data[now_model][now_samples]);
    }
  }
  for (now_model =0; now_model < adatabase->num_ref_model; now_model++) {
    
    now_samples = (int)(controlInfo->include_observed != 0);
    amodel = &(adatabase->entries[adatabase->selected_models[now_model]]);
    
    if (controlInfo->hole_syn_init_iter == 0) {
      now_samples  = Pick_From_Synthesized_Image(controlInfo,
						 ffamily,
						 holefamily,
						 ahole,
						 cur_hole,
						 now_model,
						 amodel,
						 syn,
						 now_samples);
    }
    if (now_samples >= ahole->num_samples) continue;
    /* We need to synthesize the image with the boundary condition
       when the given synthesized image is not valid. */
    /* Use the current  model lambdas */
    for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
      filter= &(ffamily->fbank[filter_no]);
      for (i=0; i < filter->bin_num; i++) {
	filter->lambda[i] = 
	  amodel->lambda_vec[ffamily->filterDim[filter_no]+i];
      }
    }
    
    /* Update the filter responses for an image initialized 
       to be random 
    */
    for (i=0; i < holefamily->hole_size; i++) {
      for (j=0; j < holefamily->hole_size; j++) {
	val = (int)(Unit_Random()*ffamily->greyLevel);
	if (val >= ffamily->greyLevel)
	  val = ffamily->greyLevel - 1;
	Update_Hole_Pixel(ffamily,
			  syn, 
			  (int)(i+row), (int)(j+col), val);
	
      }
    }
    /*
    sprintf(fname, "%s_%d_%d_init.pgm",
	    controlInfo->prefix, cur_hole, now_model);
    Write_An_Image_Int(syn, (int)(256/ffamily->greyLevel), fname);
    */
    save_hole_syn_init_iter = controlInfo->hole_syn_init_iter;
    if (controlInfo->hole_syn_init_iter  <=0) 
      controlInfo->hole_syn_init_iter = 200;
    printf("Generating %d samples from model %d (%s) ... \n",
	   ahole->num_samples-now_samples,
	   adatabase->selected_models[now_model],
	   &(amodel->fname[adatabase->startIndex]));
    iter = 0;
    do {
      if ( (iter %20) ==0) {
	printf("%d ", iter);
	fflush(stdout);
      }
      for (k=0; k < (holefamily->hole_size*holefamily->hole_size); k++) {
	do {
	  crow = (int) (Unit_Random()*holefamily->hole_size);
	  ccol = (int) (Unit_Random()*holefamily->hole_size);
	} while ( (crow == holefamily->hole_size) ||
		  (ccol == holefamily->hole_size));
	crow += row;
	ccol += col;
	Update_Patch(ffamily, syn, crow, ccol);
	Calc_Energy(ffamily, crow, ccol, energy);
	least=energy[0];
	for(val=1; val< ffamily->greyLevel; val++) {
	  if ( least>energy[val] ) least=energy[val];
	}
	sum=0;      /* shift and normalize the probability */
	for(val=0; val< ffamily->greyLevel; val++) {
	  sum+=prob[val]=exp(-(energy[val]-least));
	}
	for(val= 0; val< ffamily->greyLevel; val++) {
	  prob[val] /= sum;
	}
	sum=0;
	for(val=0; val< ffamily->greyLevel; val++) {
	  prob[val] += sum;
	  sum=prob[val];
	}
	/** choose the pixel value by the cdf **/
	r = Unit_Random(); val=0;
	while (r > prob[val] ) val++;
	if( val >= ffamily->greyLevel)  val=ffamily->greyLevel-1;
	Update_Map(ffamily, crow, ccol, val);
	syn->data[crow][ccol]=val;
	
	if (holefamily->hole_map.data[crow][ccol] ==0) {
	  printf("Background pixel (%d,%d) is updated mistakenly.\n",
		 ccol, crow);
	}
      }
      if (iter >= controlInfo->hole_syn_init_iter &&
	  ( ( (iter-controlInfo->hole_syn_init_iter) % 
	      controlInfo->hole_syn_every_iter) ==0) ) {
	
	Compute_Hole_Hist_Into_Vector(ffamily,
				      holefamily,
				      ahole,
			   ahole->hist.data[now_model][now_samples]);
        /*
	sprintf(fname, "%s_%d_%d_%d.pgm",
		controlInfo->prefix, cur_hole, now_model, now_samples);
	Write_An_Image_Int(syn, (int)(256/ffamily->greyLevel), fname);
        */
	now_samples++;
      }
      if (now_samples >= ahole->num_samples) break;
      iter++;
    } while(now_samples < ahole->num_samples);
    printf("\n");
    controlInfo->hole_syn_init_iter = save_hole_syn_init_iter;
  }
  /* Restore the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      syn->data[i+row][j+col] = 
	holefamily->saved_hole_patch.data[i][j];
    }
  }
  
  /* Restore the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	filter->map.data[i][j] = 
	  holefamily->saved_filter_map.data[filter_no][k1][k2];
      }
    }
  }
  /* Restore the previous lambda's */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
     filter->lambda[i] = 
       holefamily->saved_lambdas[ffamily->filterDim[filter_no]+i];
    }
  }
  free(energy);
  free(prob);
  return;
}


int Generate_All_Holes(CONTROL_INFO *controlInfo, 
		       FILTERBANK *ffamily,
		       IMAGE_DATABASE *adatabase,
		       DIGGED_HOLES *holefamily,
		       IMAGEINT *syn)
{
  ONE_HOLE *ahole;
  int k;
  
  for (k=0; k < holefamily->nhole; k++) {
    ahole = &(holefamily->holes[k]);
    Generate_Hole_All_Model(controlInfo,
			    ffamily,
			    adatabase,
			    holefamily,
			    ahole,
			    k,
			    syn);
  }
  return k;
}

int Generate_Hist_From_Satellite(FILTERBANK *ffamily,
				 IMAGE_DATABASE *adatabase,
				 DIGGED_HOLES *holefamily)
{
  int i,j,k;
  int now_model;
  ONE_IMAGE_ENTRY *amodel;
  double *sample_energy, *sample_prob;
  float *current_lambdas;
  int filter_no;
  FILTER *filter;
  int cur_hole;
  float least, sum;
  
  sample_energy = (double *)malloc(sizeof(double)*
				  holefamily->num_samples);
  sample_prob = (double *)malloc(sizeof(double)*
				holefamily->num_samples);
  current_lambdas = (float *)malloc(sizeof(float)*
				    ffamily->totalBin);
  /* Convert current lambdas into a vector too for convenience */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
      current_lambdas[ffamily->filterDim[filter_no]+i] = 
	filter->lambda[i];
    }
  }
  /* Clean the local hist */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
      filter->hist[i] = 0.0;
    }
  }
  
  for(cur_hole=0; cur_hole < holefamily->nhole; cur_hole++) {
    for(now_model=0; now_model < adatabase->num_ref_model; now_model++) {
      amodel = &(adatabase->entries[adatabase->selected_models[now_model]]);
      
      for (k=0; k < holefamily->num_samples; k++)
	sample_energy[k] = 0.0;
      
      for (k=0; k < holefamily->num_samples; k++) {
	for (i=0; i <ffamily->totalBin; i++) {
	  /* Here includes all the filters in a vector format */
	  sample_energy[k] += (current_lambdas[i]-amodel->lambda_vec[i]) *
	    holefamily->holes[cur_hole].hist.data[now_model][k][i];
	}
      }
      least = sample_energy[0];
      for (k=1; k < holefamily->num_samples; k++) {
	if (least > sample_energy[k]) 
	  least = sample_energy[k];
      }
      sum = 0.0;
      for (k=0; k < holefamily->num_samples; k++) {
	sample_prob[k] = exp(0.-(sample_energy[k]-least));
	sum += sample_prob[k];
      }
      for (k=0; k < holefamily->num_samples; k++) {
	sample_prob[k] /= sum;
      }
      
      for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
	filter= &(ffamily->fbank[filter_no]);
	for (i=0; i < filter->bin_num; i++) {
	  j = ffamily->filterDim[filter_no];
	  for (k=0; k < holefamily->num_samples; k++) {
	    filter->hist[i] += sample_prob[k] *
	      holefamily->holes[cur_hole].hist.data[now_model][k][i+j];
	  }
	}
      }
    }
  }
  /* Now we need to normalize the local histogram */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    sum = 0.0;
    for (i=0; i < filter->bin_num; i++) {
      sum += filter->hist[i];
    }
    if (sum >= 0.1) {
      for (i=0; i < filter->bin_num; i++) {
	filter->hist[i] *= (ffamily->norm/sum);
      }
    }
    else {
      printf("Local histogram for filter %d is invalid.\n\t", filter_no);
      for (i=0; i < filter->bin_num; i++) {
	printf("%6.2f ", filter->hist[i]);
      }
      printf("\n");
    }
  }
  free(sample_energy);
  free(sample_prob);
  free(current_lambdas);
  return 0;
}



/* This is for pseudo likelihood */
int Generate_Pseudo_Hist(FILTERBANK *ffamily,
			 IMAGE_DATABASE *adatabase,
			 DIGGED_HOLES *holefamily,
			 IMAGEINT *syn)
{
  int i,j,k;
  int now_model;
  double *sample_energy, *sample_prob;
  int filter_no;
  FILTER *filter;
  int cur_hole;
  float least, sum;
  
  if (holefamily->hole_size !=1) {
    fprintf(stderr, "Pseudolikelihood Estimator CANNOT be applied when ");
    fprintf(stderr, "size of hole is %d\n", holefamily->hole_size);
    exit(-1);
  }
  sample_energy = (double *)malloc(sizeof(double)*
				   ffamily->greyLevel);
  sample_prob = (double *)malloc(sizeof(double)*
				 ffamily->greyLevel);
  /* Clean the local hist */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
      filter->hist[i] = 0.0;
    }
  }
  
  for(cur_hole=0; cur_hole < holefamily->nhole; cur_hole++) {
    i = holefamily->holes[cur_hole].row;
    j = holefamily->holes[cur_hole].col;
    Update_Patch(ffamily, syn, i, j);
    Calc_Energy_With_Patch_Hist(ffamily, i, j, sample_energy,
				&(holefamily->patch_hist));
    
    least = sample_energy[0];
    for (k=1; k < ffamily->greyLevel; k++) {
      if (least > sample_energy[k]) 
	least = sample_energy[k];
    }
    sum = 0.0;
    for (k=0; k < ffamily->greyLevel; k++) {
      sample_prob[k] = exp(0.-(sample_energy[k]-least));
      sum += sample_prob[k];
    }
    for (k=0; k < ffamily->greyLevel; k++) {
      sample_prob[k] /= sum;
    }
    
    /* Compute the local histogram */
    for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
      filter= &(ffamily->fbank[filter_no]);
      j = ffamily->filterDim[filter_no];
      for (i=0; i < filter->bin_num; i++) {
	for (k=0; k < ffamily->greyLevel; k++) {
	  filter->hist[i] += sample_prob[k] *
	    holefamily->patch_hist.data[k][j+i];
	}
      }
    }
  }

  /* Now we need to normalize the local histogram */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    sum = 0.0;
    for (i=0; i < filter->bin_num; i++) {
      sum += filter->hist[i];
    }
    if (sum >= 0.1) {
      for (i=0; i < filter->bin_num; i++) {
	filter->hist[i] *= (ffamily->norm/sum);
      }
    }
    else {
      printf("Local histogram for filter %d is invalid.\n\t", filter_no);
      for (i=0; i < filter->bin_num; i++) {
	printf("%6.2f ", filter->hist[i]);
      }
      printf("\n");
    }
  }
  free(sample_energy);
  free(sample_prob);
  return 0;
}



void Generate_An_Pseudo_Hole(CONTROL_INFO *controlInfo, 
			     FILTERBANK *ffamily,
			     IMAGE_DATABASE *adatabase,
			     DIGGED_HOLES *holefamily,
			     ONE_HOLE *ahole,
			     int cur_hole,
			     IMAGEINT *syn)
{
  int i, j,k, filter_no;
  int k1, k2, iter;
  int crow, ccol;
  float least, sum, r;
  int val;
  FILTER *filter;
  int index;
  int row, col;
  
  
  if (holefamily->hole_size !=1) {
    fprintf(stderr,"Error: This function only works for MPLE with hole=1\n");
    fprintf(stderr,"       However, now the hole size is %d\n",
	    holefamily->hole_size);
    exit(-1);
  }
  
  row = ahole->row;
  col = ahole->col;
  /* Save the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      holefamily->saved_hole_patch.data[i][j] = 
	syn->data[i+row][j+col];
    }
  }
  /* Save the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	holefamily->saved_filter_map.data[filter_no][k1][k2] = 
	  filter->map.data[i][j];
      }
    }
  }
  
 
  for (val =0; val < ffamily->greyLevel; val++) {
    Update_Hole_Pixel(ffamily, syn, ahole->row, 
		      ahole->col, 
		      val);
    Compute_Hole_Pseudo_Hist_Into_Vector(ffamily,
				  holefamily,
				  ahole,
				  ahole->hist.data[0][val]);
  }
  /* Restore the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      syn->data[i+row][j+col] = 
	holefamily->saved_hole_patch.data[i][j];
    }
  }
  
  /* Restore the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	filter->map.data[i][j] = 
	  holefamily->saved_filter_map.data[filter_no][k1][k2];
      }
    }
  }
  
  return;
}


int Generate_Pseudo_All_Holes(CONTROL_INFO *controlInfo, 
			      FILTERBANK *ffamily,
			      IMAGE_DATABASE *adatabase,
			      DIGGED_HOLES *holefamily,
			      IMAGEINT *syn)
{
  ONE_HOLE *ahole;
  int k;
  
  for (k=0; k < holefamily->nhole; k++) {
    ahole = &(holefamily->holes[k]);
    Generate_An_Pseudo_Hole(controlInfo,
			    ffamily,
			    adatabase,
			    holefamily,
			    ahole,
			    k,
			    syn);
  }
  return k;
}

void Synthesize_Hole_Frame_Hole(CONTROL_INFO *controlInfo, 
				FILTERBANK *ffamily,
				DIGGED_HOLES *holefamily,
				ONE_HOLE *ahole,
				int cur_hole,
				IMAGEINT *obs,
				IMAGEINT *syn)
{
  int i, j,k, filter_no;
  int k1, k2, iter;
  int crow, ccol;
  float least, sum, r;
  int val;
  FILTER *filter;
  int index;
  int row, col;
  float *energy;
  float *prob;
  ONE_IMAGE_ENTRY *amodel;
  int now_model;
  int now_samples;
  
  char fname[256];
  energy = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  prob = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  
  row = ahole->row;
  col = ahole->col;
  /* Save the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      holefamily->saved_hole_patch.data[i][j] = 
	obs->data[i+row][j+col];
    }
  }
  /* Save the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	holefamily->saved_filter_map.data[filter_no][k1][k2] = 
	  filter->map.data[i][j];
      }
    }
  }
  
  /* Update the filter responses for an image initialized 
     to be random 
  */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      val = syn->data[i+row][j+col];
      Update_Hole_Pixel(ffamily,
			obs, 
			(int)(i+row), (int)(j+col), val);
      
    }
  }
  
  for( iter = 0; iter < controlInfo->learningUpdate; iter++) {
    for (k=0; k < (holefamily->hole_size*holefamily->hole_size); k++) {
      do {
	crow = (int) (Unit_Random()*holefamily->hole_size);
	ccol = (int) (Unit_Random()*holefamily->hole_size);
      } while ( (crow == holefamily->hole_size) ||
		(ccol == holefamily->hole_size));
      crow += row;
      ccol += col;
      Update_Patch(ffamily, obs, crow, ccol);
      Calc_Energy(ffamily, crow, ccol, energy);
      least=energy[0];
      for(val=1; val< ffamily->greyLevel; val++) {
	if ( least>energy[val] ) least=energy[val];
      }
      sum=0;      /* shift and normalize the probability */
      for(val=0; val< ffamily->greyLevel; val++) {
	sum+=prob[val]=exp(-(energy[val]-least));
      }
      for(val= 0; val< ffamily->greyLevel; val++) {
	prob[val] /= sum;
      }
      sum=0;
      for(val=0; val< ffamily->greyLevel; val++) {
	prob[val] += sum;
	sum=prob[val];
      }
      /** choose the pixel value by the cdf **/
      r = Unit_Random(); val=0;
      while (r > prob[val] ) val++;
      if( val >= ffamily->greyLevel)  val=ffamily->greyLevel-1;
      Update_Map(ffamily, crow, ccol, val);
      obs->data[crow][ccol]=val;
      syn->data[crow][ccol]=val;
      if (holefamily->hole_map.data[crow][ccol] ==0) {
	printf("Background pixel (%d,%d) is updated mistakenly.\n",
	       ccol, crow);
      }
    }
  }
  
  Accumalate_Hole_Local_Hist(ffamily,
			     holefamily,
			     ahole);
  /*
    sprintf(fname, "%s_%d_%d_%d.pgm",
    controlInfo->prefix, cur_hole, now_model, now_samples);
    Write_An_Image_Int(syn, (int)(256/ffamily->greyLevel), fname);
  */ 
 
  /* Restore the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      obs->data[i+row][j+col] = 
	holefamily->saved_hole_patch.data[i][j];
    }
  }
  
  /* Restore the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	filter->map.data[i][j] = 
	  holefamily->saved_filter_map.data[filter_no][k1][k2];
      }
    }
  }
  
  free(energy);
  free(prob);
  return;
}


int Generate_Hist_Frame_Holes(CONTROL_INFO *controlInfo, 
			      FILTERBANK *ffamily,
			      DIGGED_HOLES *holefamily,
			      IMAGEINT *obs,
			      IMAGEINT *syn)
{
  ONE_HOLE *ahole;
  int i,k,filter_no;
  FILTER *filter;
  float sum;
  /* Clean the local hist */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
      filter->hist[i] = 0.0;
    }
  }
  for (k=0; k < holefamily->nhole; k++) {
    ahole = &(holefamily->holes[k]);
    Synthesize_Hole_Frame_Hole(controlInfo, 
			       ffamily,
			       holefamily,
			       ahole,
			       k,
			       obs,
			       syn);
  }

  /* Now we need to normalize the local histogram */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    sum = 0.0;
    for (i=0; i < filter->bin_num; i++) {
      sum += filter->hist[i];
    }
    if (sum >= 0.1) {
      for (i=0; i < filter->bin_num; i++) {
	filter->hist[i] *= (ffamily->norm/sum);
      }
    }
    else {
      printf("Local histogram for filter %d is invalid.\n\t", filter_no);
      for (i=0; i < filter->bin_num; i++) {
	printf("%6.2f ", filter->hist[i]);
      }
      printf("\n");
    }
  }
  return holefamily->nhole;
}


void Calculate_MCMC_Each_Hole(CONTROL_INFO *controlInfo, 
			      FILTERBANK *ffamily,
			      IMAGEFLOAT *all_lambdas,
			      DIGGED_HOLES *holefamily,
			      ONE_HOLE *ahole,
			      int cur_hole,
			      IMAGEINT *syn,
			      double *res_vect)
{
  int i, j,k, filter_no;
  int k1, k2, iter;
  int crow, ccol;
  float least, sum, r;
  int val;
  FILTER *filter;
  int index;
  int row, col;
  float *energy;
  float *prob;
  ONE_IMAGE_ENTRY *amodel;
  int now_model;
  int now_samples;
  int save_hole_syn_init_iter;
  char fname[256];  
  int iter_lambda;
  int num_samples;
  float *hole_hist;
  double tmp_d;

  row = ahole->row;
  col = ahole->col;
  
  energy = Create_Array(ffamily->greyLevel);
  prob = Create_Array(ffamily->greyLevel);
  hole_hist = Create_Array(ffamily->totalBin);
  
  /* Save the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      holefamily->saved_hole_patch.data[i][j] = 
	syn->data[i+row][j+col];
    }
  }
  /* Save the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	holefamily->saved_filter_map.data[filter_no][k1][k2] = 
	  filter->map.data[i][j];
      }
    }
  }
  /* Save the current lambda's */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
      holefamily->saved_lambdas[ffamily->filterDim[filter_no]+i]
	= filter->lambda[i];
    }
  }

  now_samples = 0;
 
  /* Res_vect: the first is Z(A)
               the second is Z(B)
               the third  is <B_A-B_B, H>
               the fourth is the result 
  */
  
  for (iter_lambda=0; iter_lambda < 4; iter_lambda++) {
    res_vect[iter_lambda] = 0.0;
  }
    
  for (iter_lambda =0; iter_lambda < 2; iter_lambda++) {
    switch(iter_lambda) {
    case 0:
      now_model = INTER_LAMBDA;
      num_samples = ahole->num_samples;
      break;
    case 1:
      now_model = FRONT_LAMBDA;
      num_samples = controlInfo->texture_KL_num_samples;
      break;
    default:
      printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
      printf("This should never happen.\n");
      exit(-1);
    }
    
    now_samples = 0;
    /* We need to synthesize the image with the boundary condition
       when the given synthesized image is not valid. */
    /* Use the current  model lambdas */
    for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
      filter= &(ffamily->fbank[filter_no]);
      for (i=0; i < filter->bin_num; i++) {
	filter->lambda[i] = 
	  all_lambdas->data[now_model][ffamily->filterDim[filter_no]+i];
      }
    }
    
    /* Update the filter responses for an image initialized 
       to be random 
    */
    for (i=0; i < holefamily->hole_size; i++) {
      for (j=0; j < holefamily->hole_size; j++) {
	val = (int)(Unit_Random()*ffamily->greyLevel);
	if (val >= ffamily->greyLevel)
	  val = ffamily->greyLevel - 1;
	Update_Hole_Pixel(ffamily,
			  syn, 
			  (int)(i+row), (int)(j+col), val);
	
      }
    }
    /*
    sprintf(fname, "%s_%d_%d_init.pgm",
	    controlInfo->prefix, cur_hole, now_model);
    Write_An_Image_Int(syn, (int)(256/ffamily->greyLevel), fname);
    */
    switch(now_model) {
    case INTER_LAMBDA:
      printf("For estimating Z(A)/Z(B), generating %d samples ",
	     num_samples);
      printf("from model %d ... \n", now_model);
      break;
    case FRONT_LAMBDA:
      printf("For estimating KL(Pb||Pa), generating %d samples ",
	     num_samples);
      printf("from model %d ... \n", now_model);
      break;
    default:
      printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
      printf("This should never happen.\n");
      exit(-1);
    }
    iter = 0;
    k2 = (controlInfo->hole_syn_init_iter + 
	  controlInfo->hole_syn_every_iter *
	  num_samples)/10;
    do {
      if ( (iter %k2) ==0) {
	printf("%d ", iter);
	fflush(stdout);
      }
      for (k=0; k < (holefamily->hole_size*holefamily->hole_size); k++) {
	do {
	  crow = (int) (Unit_Random()*holefamily->hole_size);
	  ccol = (int) (Unit_Random()*holefamily->hole_size);
	} while ( (crow == holefamily->hole_size) ||
		  (ccol == holefamily->hole_size));
	crow += row;
	ccol += col;
	Update_Patch(ffamily, syn, crow, ccol);
	Calc_Energy(ffamily, crow, ccol, energy);
	least=energy[0];
	for(val=1; val< ffamily->greyLevel; val++) {
	  if ( least>energy[val] ) least=energy[val];
	}
	sum=0;      /* shift and normalize the probability */
	for(val=0; val< ffamily->greyLevel; val++) {
	  sum+=prob[val]=exp(-(energy[val]-least));
	}
	for(val= 0; val< ffamily->greyLevel; val++) {
	  prob[val] /= sum;
	}
	sum=0;
	for(val=0; val< ffamily->greyLevel; val++) {
	  prob[val] += sum;
	  sum=prob[val];
	}
	/** choose the pixel value by the cdf **/
	r = Unit_Random(); val=0;
	while (r > prob[val] ) val++;
	if( val >= ffamily->greyLevel)  val=ffamily->greyLevel-1;
	Update_Map(ffamily, crow, ccol, val);
	syn->data[crow][ccol]=val;
	
	if (holefamily->hole_map.data[crow][ccol] ==0) {
	  printf("Background pixel (%d,%d) is updated mistakenly.\n",
		 ccol, crow);
	}
      }
      if (iter >= controlInfo->hole_syn_init_iter &&
	  ( ( (iter-controlInfo->hole_syn_init_iter) % 
	      controlInfo->hole_syn_every_iter) ==0) ) {
	
	Compute_Hole_Hist_Into_Vector_With_Bound(ffamily,
						 holefamily,
						 ahole,
						 hole_hist);
	switch(now_model) {
	case INTER_LAMBDA:
	  for (i=BACK_LAMBDA; i <= FRONT_LAMBDA; i++) {
	    tmp_d = 0.0;
	    for (j=0; j < ffamily->totalBin; j++) {
	      tmp_d += (double)(hole_hist[j] * 
				(all_lambdas->data[i][j] - 
				 all_lambdas->data[now_model][j]));
	    }
	    tmp_d = 0.0-tmp_d;
	    res_vect[i] += exp(tmp_d);
	  }
	  break;
	case FRONT_LAMBDA:
	  tmp_d = 0.0;
	  for (j=0; j < ffamily->totalBin; j++) {
	    tmp_d += (double)(hole_hist[j] * 
			      (all_lambdas->data[BACK_LAMBDA][j] - 
			       all_lambdas->data[now_model][j]));
	  }
	  res_vect[2] += tmp_d/((double)num_samples);
	  break;
	default:
	  printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
	  printf("This should never happen.\n");
	  exit(-1);
	}
	now_samples++;
      }
      if (now_samples >= num_samples) break;
      iter++;
    } while(now_samples < num_samples);  
    printf("%d -- Done.\n", iter);
  }
  res_vect[3] = log((double)(res_vect[0]/res_vect[1])) +
    res_vect[2];
  /* Restore the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      syn->data[i+row][j+col] = 
	holefamily->saved_hole_patch.data[i][j];
    }
  }
  
  /* Restore the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	filter->map.data[i][j] = 
	  holefamily->saved_filter_map.data[filter_no][k1][k2];
      }
    }
  }
  /* Restore the previous lambda's */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
     filter->lambda[i] = 
       holefamily->saved_lambdas[ffamily->filterDim[filter_no]+i];
    }
  }
  free(energy);
  free(prob);
  free(hole_hist);
  return;
}



int Calculate_MCMC_All_Holes(CONTROL_INFO *controlInfo, 
			     FILTERBANK *ffamily,
			     IMAGEFLOAT *all_lambdas,
			     DIGGED_HOLES *holefamily,
			     IMAGEINT *syn,
			     IMAGEDOUBLE *res_image)

{
  ONE_HOLE *ahole;
  int k;
  double   total_KL;
  total_KL = 0.0;
  
  for (k=0; k < holefamily->nhole; k++) {
    ahole = &(holefamily->holes[k]);
    Calculate_MCMC_Each_Hole(controlInfo,
			     ffamily,
			     all_lambdas,
			     holefamily,
			     ahole,
			     k,
			     syn,
			     res_image->data[k]);
    total_KL += res_image->data[k][3];
    printf("Now hole %d/%d: Z(A)=%12.10lf  Z(B)=%12.10lf  ", 
	   k+1, holefamily->nhole,
	   res_image->data[k][0],
	   res_image->data[k][1]);
    printf("<Ba-Bb,H>=%12.10lf  KL=%12.10lf\n",
	   res_image->data[k][2],
	   res_image->data[k][3]);
    printf("\tAverage per hole up to now is %12.10lf\n",
	   (double)(total_KL/((double)(k+1))));
  }
  return k;
}


void Calculate_MCMC_Mix_Rate_From_A_Hole(CONTROL_INFO *controlInfo, 
					 FILTERBANK *ffamily,
					 IMAGEFLOAT *all_lambdas,
					 DIGGED_HOLES *holefamily,
					 ONE_HOLE *ahole,
					 int cur_hole,
					 IMAGEINT *syn,
					 double *res_vect)
{
  int i, j,k, filter_no;
  int k1, k2, iter;
  int crow, ccol;
  float least, sum, r;
  int val;
  FILTER *filter;
  int index;
  int row, col;
  float *energy;
  float *prob;
  ONE_IMAGE_ENTRY *amodel;
  int now_model;
  int now_samples;
  int save_hole_syn_init_iter;
  char fname[256];  
  int iter_lambda;
  int num_samples;
  float *hole_hist;
  float *inter_lambda;
  double tmp_d;
  float  mix_rate;
  int    calc_KL;
  row = ahole->row;
  col = ahole->col;
  
  energy = Create_Array(ffamily->greyLevel);
  prob = Create_Array(ffamily->greyLevel);
  hole_hist = Create_Array(ffamily->totalBin);
  inter_lambda = Create_Array(ffamily->totalBin);
  /* Save the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      holefamily->saved_hole_patch.data[i][j] = 
	syn->data[i+row][j+col];
    }
  }
  /* Save the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	holefamily->saved_filter_map.data[filter_no][k1][k2] = 
	  filter->map.data[i][j];
      }
    }
  }
  /* Save the current lambda's */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
      holefamily->saved_lambdas[ffamily->filterDim[filter_no]+i]
	= filter->lambda[i];
    }
  }
  
    
  for (iter_lambda=0; iter_lambda < 4; iter_lambda++) {
    res_vect[iter_lambda] = 0.0;
  }
  
    
  for (i=0; i < all_lambdas->ncol; i++) {
    inter_lambda[i] = all_lambdas->data[INTER_LAMBDA][i];
  }
  
  calc_KL = 2;
  for (mix_rate =0.05; mix_rate < 0.96; mix_rate += 0.05) {
    for (i=0; i < all_lambdas->ncol; i++) {
      all_lambdas->data[INTER_LAMBDA][i] = 
	all_lambdas->data[BACK_LAMBDA][i] * mix_rate +
	all_lambdas->data[FRONT_LAMBDA][i] * (1.0-mix_rate);
    }
    now_samples = 0;
    /* Res_vect: the first is Z(A)
       the second is Z(B)
       the third  is <B_A-B_B, H>
       the fourth is the result 
    */
    for (iter_lambda=0; iter_lambda < 2; iter_lambda++) {
      res_vect[iter_lambda] = 0.0;
    }
    for (iter_lambda =0; iter_lambda < calc_KL; iter_lambda++) {
      switch(iter_lambda) {
      case 0:
	now_model = INTER_LAMBDA;
	num_samples = ahole->num_samples;
	break;
      case 1:
	now_model = FRONT_LAMBDA;
	num_samples = controlInfo->texture_KL_num_samples;
	break;
      default:
	printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
	printf("This should never happen.\n");
	exit(-1);
      }
      
      now_samples = 0;
      /* We need to synthesize the image with the boundary condition
	 when the given synthesized image is not valid. */
      /* Use the current  model lambdas */
      for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
	filter= &(ffamily->fbank[filter_no]);
	for (i=0; i < filter->bin_num; i++) {
	  filter->lambda[i] = 
	    all_lambdas->data[now_model][ffamily->filterDim[filter_no]+i];
	}
      }
      
      /* Update the filter responses for an image initialized 
	 to be random 
      */
      for (i=0; i < holefamily->hole_size; i++) {
	for (j=0; j < holefamily->hole_size; j++) {
	  val = (int)(Unit_Random()*ffamily->greyLevel);
	  if (val >= ffamily->greyLevel)
	    val = ffamily->greyLevel - 1;
	  Update_Hole_Pixel(ffamily,
			    syn, 
			    (int)(i+row), (int)(j+col), val);
	  
	}
      }
      /*
	sprintf(fname, "%s_%d_%d_init.pgm",
	controlInfo->prefix, cur_hole, now_model);
	Write_An_Image_Int(syn, (int)(256/ffamily->greyLevel), fname);
      */
      switch(now_model) {
      case INTER_LAMBDA:
	printf("For estimating Z(A)/Z(B), generating %d samples ",
	       num_samples);
	printf("from model %d ... \n", now_model);
	break;
      case FRONT_LAMBDA:
	printf("For estimating KL(Pb||Pa), generating %d samples ",
	       num_samples);
	printf("from model %d ... \n", now_model);
	break;
      default:
	printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
	printf("This should never happen.\n");
	exit(-1);
      }
      iter = 0;
      k2 = (controlInfo->hole_syn_init_iter + 
	    controlInfo->hole_syn_every_iter *
	    num_samples)/10;
      do {
	if ( (iter %k2) ==0) {
	  printf("%d ", iter);
	  fflush(stdout);
	}
	for (k=0; k < (holefamily->hole_size*holefamily->hole_size); k++) {
	  do {
	    crow = (int) (Unit_Random()*holefamily->hole_size);
	    ccol = (int) (Unit_Random()*holefamily->hole_size);
	  } while ( (crow == holefamily->hole_size) ||
		    (ccol == holefamily->hole_size));
	  crow += row;
	  ccol += col;
	  Update_Patch(ffamily, syn, crow, ccol);
	  Calc_Energy(ffamily, crow, ccol, energy);
	  least=energy[0];
	  for(val=1; val< ffamily->greyLevel; val++) {
	    if ( least>energy[val] ) least=energy[val];
	  }
	  sum=0;      /* shift and normalize the probability */
	  for(val=0; val< ffamily->greyLevel; val++) {
	    sum+=prob[val]=exp(-(energy[val]-least));
	  }
	  for(val= 0; val< ffamily->greyLevel; val++) {
	    prob[val] /= sum;
	  }
	  sum=0;
	  for(val=0; val< ffamily->greyLevel; val++) {
	    prob[val] += sum;
	    sum=prob[val];
	  }
	  /** choose the pixel value by the cdf **/
	  r = Unit_Random(); val=0;
	  while (r > prob[val] ) val++;
	  if( val >= ffamily->greyLevel)  val=ffamily->greyLevel-1;
	  Update_Map(ffamily, crow, ccol, val);
	  syn->data[crow][ccol]=val;
	  
	  if (holefamily->hole_map.data[crow][ccol] ==0) {
	    printf("Background pixel (%d,%d) is updated mistakenly.\n",
		   ccol, crow);
	  }
	}
	if (iter >= controlInfo->hole_syn_init_iter &&
	    ( ( (iter-controlInfo->hole_syn_init_iter) % 
		controlInfo->hole_syn_every_iter) ==0) ) {
	  
	  Compute_Hole_Hist_Into_Vector_With_Bound(ffamily,
						   holefamily,
						   ahole,
						   hole_hist);
	  switch(now_model) {
	  case INTER_LAMBDA:
	    for (i=BACK_LAMBDA; i <= FRONT_LAMBDA; i++) {
	      tmp_d = 0.0;
	      for (j=0; j < ffamily->totalBin; j++) {
		tmp_d += (double)(hole_hist[j] * 
				  (all_lambdas->data[i][j] - 
				   all_lambdas->data[now_model][j]));
	      }
	      tmp_d = 0.0-tmp_d;
	      res_vect[i] += exp(tmp_d);
	    }
	    break;
	  case FRONT_LAMBDA:
	    tmp_d = 0.0;
	    for (j=0; j < ffamily->totalBin; j++) {
	      tmp_d += (double)(hole_hist[j] * 
				(all_lambdas->data[BACK_LAMBDA][j] - 
				 all_lambdas->data[now_model][j]));
	    }
	    res_vect[2] += tmp_d/((double)num_samples);
	    break;
	  default:
	    printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
	    printf("This should never happen.\n");
	    exit(-1);
	  }
	  now_samples++;
	}
	if (now_samples >= num_samples) break;
	iter++;
      } while(now_samples < num_samples);  
      printf("%d -- Done.\n", iter);
    }
    res_vect[3] = log((double)(res_vect[0]/res_vect[1]));
      
    printf("Now mix rate = %6.4f ", mix_rate);
    printf("Hole %d/%d\n\tZ(A)=%12.10lf  Z(B)=%12.10lf\n\t", 
	   cur_hole, holefamily->nhole,
	   res_vect[0],
	   res_vect[1]);
    printf("log(Z(A)/Z(B))=%12.10lf <Ba-Bb,H>=%12.10lf\n\tKL=%12.10lf\n",
	   res_vect[3],
	   res_vect[2],
	   res_vect[3]+res_vect[2]);
    res_vect[3] += res_vect[2];
    calc_KL = 1;
  }
  
  
  /* Restore the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      syn->data[i+row][j+col] = 
	holefamily->saved_hole_patch.data[i][j];
    }
  }
  
  /* Restore the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	filter->map.data[i][j] = 
	  holefamily->saved_filter_map.data[filter_no][k1][k2];
      }
    }
  }
  /* Restore the previous lambda's */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
     filter->lambda[i] = 
       holefamily->saved_lambdas[ffamily->filterDim[filter_no]+i];
    }
  }
  for (i=0; i < all_lambdas->ncol; i++) {
    all_lambdas->data[INTER_LAMBDA][i] = inter_lambda[i];
  }
  
  free(energy);
  free(prob);
  free(hole_hist);
  free(inter_lambda);
  return;
}


int Calculate_MCMC_All_Holes_Mix_Rate(CONTROL_INFO *controlInfo, 
				      FILTERBANK *ffamily,
				      IMAGEFLOAT *all_lambdas,
				      DIGGED_HOLES *holefamily,
				      IMAGEINT *syn,
				      IMAGEDOUBLE *res_image)
     
{
  ONE_HOLE *ahole;
  int k;
  double   total_KL;
  total_KL = 0.0;
  
  for (k=0; k < holefamily->nhole; k++) {
    ahole = &(holefamily->holes[k]);
    Calculate_MCMC_Mix_Rate_From_A_Hole(controlInfo,
			     ffamily,
			     all_lambdas,
			     holefamily,
			     ahole,
			     k,
			     syn,
			     res_image->data[k]);
    total_KL += res_image->data[k][3];
    printf("Now hole %d/%d: Z(A)=%12.10lf  Z(B)=%12.10lf  ", 
	   k+1, holefamily->nhole,
	   res_image->data[k][0],
	   res_image->data[k][1]);
    printf("<Ba-Bb,H>=%12.10lf  KL=%12.10lf\n",
	   res_image->data[k][2],
	   res_image->data[k][3]);
    printf("\tAverage per hole up to now is %12.10lf\n",
	   (double)(total_KL/((double)(k+1))));
  }
  return k;
}
