#if !defined(HOLE_UTIL_H_H)
#define HOLE_UTIL_H_H
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "type-def.h"
#include "util.h"
#include "functions.h"
#include "imageio.h"
#include "filter-util.h"

#if defined(HOLE_SOURCE_C_C)
#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif

EXTERN_FLAG  int Create_Holes(CONTROL_INFO *controlInfo, 
			      FILTERBANK *ffamily,
			      IMAGE_DATABASE *adatabase,
			      IMAGEINT *animage,
			      DIGGED_HOLES *digged,
			      int redigged_flag);
EXTERN_FLAG void Free_Holes(DIGGED_HOLES *digged);

EXTERN_FLAG void Update_Hole_Pixel(FILTERBANK *ffamily,
		       IMAGEINT *syn,
		       int row, int col, int val);

EXTERN_FLAG void Compute_Hole_Hist_Into_Vector(FILTERBANK *ffamily,
					       DIGGED_HOLES *holefamily,
					       ONE_HOLE *ahole,
					       float *hist_vect);
EXTERN_FLAG 
void Compute_Hole_Hist_Into_Vector_With_Bound(FILTERBANK *ffamily,
					      DIGGED_HOLES *holefamily,
					      ONE_HOLE *ahole,
					      float *hist_vect);

EXTERN_FLAG void Compute_Hole_Pseudo_Hist_Into_Vector(FILTERBANK *ffamily,
						      DIGGED_HOLES *holefamily,
						      ONE_HOLE *ahole,
						      float *hist_vect);

EXTERN_FLAG int Pick_From_Synthesized_Image(CONTROL_INFO *controlInfo,
					    FILTERBANK *ffamily,
					    DIGGED_HOLES *holefamily,
					    ONE_HOLE *ahole,
					    int cur_hole,
					    int now_model,
					    ONE_IMAGE_ENTRY *amodel,
					    IMAGEINT *syn,
					    int  now_samples);

EXTERN_FLAG void Generate_Hole_All_Model(CONTROL_INFO *controlInfo, 
					 FILTERBANK *ffamily,
					 IMAGE_DATABASE *adatabase,
					 DIGGED_HOLES *holefamily,
					 ONE_HOLE *ahole,
					 int cur_hole,
					 IMAGEINT *syn);

EXTERN_FLAG int Generate_All_Holes(CONTROL_INFO *controlInfo, 
				   FILTERBANK *ffamily,
				   IMAGE_DATABASE *adatabase,
				   DIGGED_HOLES *holefamily,
				   IMAGEINT *syn);

EXTERN_FLAG int Generate_Hist_From_Satellite(FILTERBANK *ffamily,
					     IMAGE_DATABASE *adatabase,
					     DIGGED_HOLES *holefamily);

EXTERN_FLAG int Generate_Pseudo_Hist(FILTERBANK *ffamily,
				     IMAGE_DATABASE *adatabase,
				     DIGGED_HOLES *holefamily,
				     IMAGEINT *syn);

EXTERN_FLAG void Generate_An_Pseudo_Hole(CONTROL_INFO *controlInfo, 
					 FILTERBANK *ffamily,
					 IMAGE_DATABASE *adatabase,
					 DIGGED_HOLES *holefamily,
					 ONE_HOLE *ahole,
					 int cur_hole,
					 IMAGEINT *syn);

EXTERN_FLAG int Generate_Pseudo_All_Holes(CONTROL_INFO *controlInfo, 
					  FILTERBANK *ffamily,
					  IMAGE_DATABASE *adatabase,
					  DIGGED_HOLES *holefamily,
					  IMAGEINT *syn);

EXTERN_FLAG void Synthesize_Hole_Frame_Hole(CONTROL_INFO *controlInfo, 
					    FILTERBANK *ffamily,
					    DIGGED_HOLES *holefamily,
					    ONE_HOLE *ahole,
					    int cur_hole,
					    IMAGEINT *obs,
					    IMAGEINT *syn);

EXTERN_FLAG int Generate_Hist_Frame_Hole(CONTROL_INFO *controlInfo, 
					 FILTERBANK *ffamily,
					 DIGGED_HOLES *holefamily,
					 IMAGEINT *obs,
					 IMAGEINT *syn);

EXTERN_FLAG 
void Calculate_MCMC_Each_Hole(CONTROL_INFO *controlInfo, 
			      FILTERBANK *ffamily,
			      IMAGEFLOAT *all_lambdas,
			      DIGGED_HOLES *holefamily,
			      ONE_HOLE *ahole,
			      int cur_hole,
			      IMAGEINT *syn,
			      double *res_vect);

EXTERN_FLAG 
int Calculate_MCMC_All_Holes(CONTROL_INFO *controlInfo, 
			     FILTERBANK *ffamily,
			     IMAGEFLOAT *all_lambdas,
			     DIGGED_HOLES *holefamily,
			     IMAGEINT *syn,
			     IMAGEDOUBLE *res_image);

EXTERN_FLAG 
void Calculate_MCMC_Mix_Rate_From_A_Hole(CONTROL_INFO *controlInfo, 
					 FILTERBANK *ffamily,
					 IMAGEFLOAT *all_lambdas,
					 DIGGED_HOLES *holefamily,
					 ONE_HOLE *ahole,
					 int cur_hole,
					 IMAGEINT *syn,
					 double *res_vect);
EXTERN_FLAG 
int Calculate_MCMC_All_Holes_Mix_Rate(CONTROL_INFO *controlInfo, 
				      FILTERBANK *ffamily,
				      IMAGEFLOAT *all_lambdas,
				      DIGGED_HOLES *holefamily,
				      IMAGEINT *syn,
				      IMAGEDOUBLE *res_image);

#undef  EXTERN_FLAG
#endif
