#define IMAGEIO_SOURCE_C_C
#include "imageio.h"

#if !defined(DELTA)
# define DELTA 1e-9
#endif

MAT_I ReadP5(char *fName, int *row, int *col)
{
  FILE *IN;
  MAT_I dArray;
  char string[32];
  int ftype;
  int i,j; 
  if ( (IN= fopen(fName,"rb"))==NULL)  {
    fprintf(stderr,"Cannot open file '%s'\n", fName);
    *row = *col = 0;
    return NULL;
  }
  fscanf(IN,"%s",string);
  if ( strcmp(string,"P5") && strcmp(string,"P2") ) {
    fprintf(stderr,"The system only works for P5 and P2 type PGM file.\n");
    fclose(IN);
    *row = *col = 0;
    return NULL;
  }
  ftype = 0;
  if (strcmp(string,"P2") == 0) {
    ftype = 1;
  }
  while (1) {
    fscanf(IN,"%s",string); 
    if (string[0] == '#') {
      while (  getc(IN) != '\n');
    }
    else {
      sscanf(string,"%d",col);
      break;
    }
  }
  fscanf(IN, "%d%d",row,&i);
  getc(IN);
  
  dArray = Create_Int_Matrix(*row, *col);
  if (ftype == 0) {
    for (i=0; i< (*row); i++) {
      for (j=0; j <(*col); j++) {
	dArray[i][j] = getc(IN);
      }
    }
  }
  else {
    for (i=0; i< (*row); i++) {
      for (j=0; j <(*col); j++) {
	fscanf(IN,"%d", &(dArray[i][j]));
      }
    }
  }

  fclose(IN);
  
  return dArray;
}




void WriteP5Char(char *fName, int scale, int row, int col, 
		 MAT_I dArray)
{
  FILE *OUT;
  int i,j;
  int c;
  if ( (OUT = fopen(fName, "wb")) == NULL) {
    fprintf(stderr,"Failed when writing file '%s'.\n", fName);
    return;
  }
  printf("Writing '%s' ..... ", fName);
  fflush(stdout);
  fprintf(OUT,"P5\n");
  fprintf(OUT,"%d %d\n%d\n",col,row,255);
  for (i=0; i<row; i++) {
    for (j=0; j< col; j++) {
      c = dArray[i][j] * scale;
      if (c > 255) c = 255;
      if (c < 0) c = 0;
      putc(c, OUT); 
    }
  }
  fclose(OUT);
  printf(" DONE.\n");
  return;
}

int Read_An_Obs_Image(char *fname, IMAGEINT *animg,
                      CONTROL_INFO *controlInfo)
{
  int i,j, k;
 
  k = Read_An_Image_Int(fname, animg);
  if (k!=0) return k;
  for (i=0; i < animg->nrow; i++) {
    for (j=0; j < animg->ncol; j++) {
      animg->data[i][j] /= (256/controlInfo->greyLevel);
    }
  }
  return k;
}



int Read_An_Image_Int(char *name, IMAGEINT *animage)
{
  if (animage->nrow >0 ) {
    Free_Image_Int(animage);
  }
  animage->data = ReadP5(name, &(animage->nrow), &(animage->ncol));
  if (animage->data == NULL) return -1;
  return 0;
}

int Write_An_Image_Int(IMAGEINT *animage, int scale, char *name)
{
  WriteP5Char(name, scale, animage->nrow, animage->ncol, animage->data);
  return;
}

int Create_An_Image_Int(int nrow, int ncol, IMAGEINT *animage)
{
  if (animage->nrow == nrow && animage->ncol == ncol) return 0;
  if (animage->nrow >0 ) {
    Free_Image_Int(animage);
  }
  animage->data = Create_Int_Matrix(nrow, ncol);
  animage->nrow = nrow;
  animage->ncol = ncol;
  return 0;
}

int Init_An_Image_Int(IMAGEINT *animage, int initval)
{
  int i, j;
  for (i=0; i < animage->nrow; i++) {
    for (j=0; j < animage->ncol; j++) {
      animage->data[i][j] = initval;
    }
  }
  return 0;
}

void Free_Image_Int(IMAGEINT *animage)
{
  if (animage->nrow >0 ) {
    Free_Int_Matrix(animage->data, animage->nrow);
    animage->nrow = 0;
  }
  return;
}


int Write_An_Image_Float(IMAGEFLOAT *animage, char *name)
{
  int i, j;
  float scale, min, max;
  IMAGEINT tmpImg;
  tmpImg.nrow = 0;
  min  = max = animage->data[0][0];
  Create_An_Image_Int(animage->nrow, animage->ncol, &tmpImg);
  for (i=0; i < animage->nrow; i++) {
    for (j=0; j<animage->ncol; j++) {
      if ( min >  animage->data[i][j])
	min = animage->data[i][j];
      if (max < animage->data[i][j])
	max = animage->data[i][j];
    }
  }
  if (max < (min+DELTA)) max = min+DELTA;
  scale = 255./(max-min);
  for (i=0; i < animage->nrow; i++) {
    for (j=0; j < animage->ncol; j++) {
      tmpImg.data[i][j] = (int)((animage->data[i][j]-min)*scale);
    }
  }
  WriteP5Char(name, (int)1, tmpImg.nrow, tmpImg.ncol, tmpImg.data);
  Free_Image_Int(&tmpImg);
  return;
}

int Create_An_Image_Float(int nrow, int ncol, IMAGEFLOAT *animage)
{
  if (animage->nrow == nrow && animage->ncol == ncol) return 0;
  if (animage->nrow >0 ) {
    Free_Image_Float(animage);
  }
  animage->data = Create_Matrix(nrow, ncol);
  animage->nrow = nrow;
  animage->ncol = ncol;
  return 0;
}


int Init_An_Image_Float(IMAGEFLOAT *animage, float cVal)
{
  int i,j;
  for (i=0; i < animage->nrow; i++) {
    for (j=0; j < animage->ncol; j++) {
      animage->data[i][j] = cVal;
    }
  }
  return 0;
}


void Free_Image_Float(IMAGEFLOAT *animage)
{
  if (animage->nrow >0 ) {
    Free_Matrix(animage->data, animage->nrow);
    animage->nrow = 0;
  }
  return;
}

int Create_An_Image_Double(int nrow, int ncol, IMAGEDOUBLE *animage)
{
  if (animage->nrow == nrow && animage->ncol == ncol) return 0;
  if (animage->nrow >0 ) {
    Free_Image_Double(animage);
  }
  animage->data = Create_Double_Matrix(nrow, ncol);
  animage->nrow = nrow;
  animage->ncol = ncol;
  return 0;
}


int Init_An_Image_Double(IMAGEDOUBLE *animage, double cVal)
{
  int i,j;
  for (i=0; i < animage->nrow; i++) {
    for (j=0; j < animage->ncol; j++) {
      animage->data[i][j] = cVal;
    }
  }
  return 0;
}


void Free_Image_Double(IMAGEDOUBLE *animage)
{
  if (animage->nrow >0 ) {
    Free_Double_Matrix(animage->data, animage->nrow);
    animage->nrow = 0;
  }
  return;
}


int Create_An_Image_Vector(int nrow, int ncol, int length,
			   IMAGEVECTOR *animage)
{
  if (animage->nrow >0 ) {
    Free_Image_Vector(animage);
  }
  animage->data = Create_3D_Matrix(nrow, ncol, length);
  animage->nrow = nrow;
  animage->ncol = ncol;
  animage->len = length;
  return 0;
}

void Free_Image_Vector(IMAGEVECTOR *animage)
{
  if (animage->nrow >0 ) {
    Free_3D_Matrix(animage->data, animage->nrow, animage->ncol);
    animage->nrow = 0;
    animage->ncol = 0;
    animage->len = 0;
  }
  return;
}





