#if !defined(IMAGEIO_H_H)
#define IMAGEIO_H_H
#include <stdio.h>
#include <stdlib.h>
#include "type-def.h"
#include "util.h"

#if defined(IMAGEIO_SOURCE_C_C)
#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif

EXTERN_FLAG MAT_I ReadP5(char *fName, int *row, int *col);
EXTERN_FLAG void WriteP5Char(char *fName, int scale, 
			     int row, int col, 
			     MAT_I dArray);

EXTERN_FLAG int Read_An_Obs_Image(char *fname, IMAGEINT *animg,
				  CONTROL_INFO *controlInfo);
EXTERN_FLAG int Read_An_Image_Int(char *name, IMAGEINT *animage);
EXTERN_FLAG int Write_An_Image_Int(IMAGEINT *animage, int scale, 
				   char *name);

EXTERN_FLAG 
int Create_An_Image_Int(int nrow, int ncol, IMAGEINT *animage);
EXTERN_FLAG
int Init_An_Image_Int(IMAGEINT *animage, int initval);
EXTERN_FLAG void Free_Image_Int(IMAGEINT *animage);

EXTERN_FLAG int Write_An_Image_Float(IMAGEFLOAT *animage, char *name);
EXTERN_FLAG int Create_An_Image_Float(int nrow, int ncol, 
				      IMAGEFLOAT *animage);
EXTERN_FLAG int Init_An_Image_Float(IMAGEFLOAT *animage, float cVal);
EXTERN_FLAG void Free_Image_Float(IMAGEFLOAT *animage);


EXTERN_FLAG int Create_An_Image_Double(int nrow, int ncol, 
				       IMAGEDOUBLE *animage);
EXTERN_FLAG int Init_An_Image_Double(IMAGEDOUBLE *animage, 
				     double cVal);
EXTERN_FLAG void Free_Image_Double(IMAGEDOUBLE *animage);

EXTERN_FLAG int Create_An_Image_Vector(int nrow, int ncol, int length,
				       IMAGEVECTOR *animage);
EXTERN_FLAG void Free_Image_Vector(IMAGEVECTOR *animage);


#undef  EXTERN_FLAG
#endif
