/*******************************************************

   this file includes the filtering operators

********************************************************/
#define JULESZ_UTIL_SOURCE_C_C
#include "julesz-util.h"

/********************************************************
   flip the pixel value according to the filters
*********************************************************/


void Flip_Julesz_Test(IMAGEINT *syn, FILTERBANK *ffamily,
		 CONTROL_INFO *controlInfo)
{
  float least, sum, r;
  int   val, i,k;
  int count, row, col;
  float *energy, *prob;
  int  sweep;
  float energyPow;
  
  sweep = syn->nrow * syn->ncol;
  energyPow = controlInfo->julesz_energyPow;
  printf("Doing one sweep with %d updates, power=%5.3f, and ",
	 sweep, energyPow);
  printf("temp=%8.4f ....\n\t ",
	 controlInfo->synTemp);
  fflush(stdout);
  energy = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  prob = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  for(count=0; count<sweep; count++) {
    printf("Please enter a pixel (col,row): ");
    scanf("%d", &col);
    if (col < 0 || col >= syn->ncol) break;
    scanf("%d", &row);
    if (row < 0 || row >= syn->nrow) break;
    
    Update_Patch_Julesz(row, col, syn, ffamily);
    
    Compute_Patch_Histogram_Julesz(ffamily);
    
    Calc_Energy_Julesz(row, col, energy, syn, ffamily, energyPow);
    printf("Raw Energy: ");
    for(val=0; val<ffamily->greyLevel; val++) {
      printf("%8.4f ", energy[val]);
    }
    printf("\n");
    for(val=0; val<ffamily->greyLevel; val++) {
      energy[val] /= controlInfo->synTemp;
    }
    
    least=energy[0];
    
    for(val= 0; val< ffamily->greyLevel; val++) {
      if(least>energy[val]) {
	least=energy[val];
      }
    }
    sum = 0.0;      /* shift and normalize the probability */
    for(val = 0; val < ffamily->greyLevel; val++)
      sum+=prob[val]=exp(-(energy[val]-least));
    
    for( val= 0; val< ffamily->greyLevel; val++)
      prob[val] /= sum;
    printf("Conditional: ");
    for( val= 0; val< ffamily->greyLevel; val++)
      printf("%8.6f ", prob[val]);
    printf("\n");
    sum=0;
    for(val=0; val< ffamily->greyLevel; val++) {
      prob[val]+=sum;
      sum=prob[val];
    }
    /** choose the pixel value by the cdf **/
    r=Unit_Random(); val = 0;
    while(r>prob[val]) val++;
    
    if( val>= ffamily->greyLevel)  
      val= ffamily->greyLevel-1;
    
    Update_Map_Julesz(row, col, val, ffamily);
    
    Update_Histogram_Julesz(val, ffamily);
    
    printf("old value: %d, new value  =%d \n",syn->data[row][col], 
	   val);
    
    /* syn->data[row][col]=val; */
    /*if ((count+1)%1000 ==0) {
      printf("Self testing for texture type %d\n", prevIndex);
      Self_Testing(ffamily,syn);
    }
    */
  }
  printf("DONE.\n");
  free(energy);
  free(prob);
  
  /* Cooling the temperature */
  controlInfo->synTemp /= controlInfo->synCoolingRatio;
  if (controlInfo->synTemp < controlInfo->synLowTemp)
    controlInfo->synTemp = controlInfo->synLowTemp;
  return;
}


void Calc_Julesz_Temp_BasedOn_Entropy(IMAGEINT *syn, 
				      FILTERBANK *ffamily,
				      CONTROL_INFO *controlInfo)
{
  float least, r;
  double sum;
  int   val, i,k,k1;
  int count, row, col;
  float **energy;
  double *prob;
  int  sweep;
  float energyPow;
  double entropy;
  double dtmp;
  float  Temp[2];
  double prev_entropy, curr_entropy;
  double desired_entropy;
  double *temp_energy;
  float  reduce_rate;

  sweep = controlInfo->entropy_num;
  if (sweep <=0) {
    return;
  }
  energyPow = controlInfo->julesz_energyPow;
  energy = Create_Matrix(controlInfo->entropy_num,
			 ffamily->greyLevel);
  temp_energy = (double *)malloc(sizeof(double)*ffamily->greyLevel);
  prob = (double *)malloc(sizeof(double)*ffamily->greyLevel);
  for(count=0; count<sweep; count++) {   
    do {
      row=(int) (Unit_Random()*syn->nrow);   
      col=(int) (Unit_Random()*syn->ncol);
    } while (row == syn->nrow || col == syn->ncol);
   
    if ((count+1)%(sweep/10) == 0) {
      printf("%d ", count);
      fflush(stdout);
    }
    
    Update_Patch_Julesz(row, col, syn, ffamily);
    
    Compute_Patch_Histogram_Julesz(ffamily);
    
    Calc_Energy_Julesz(row, col, energy[count], syn, ffamily, energyPow);

    val = syn->data[row][col];
    
    Update_Map_Julesz(row, col, val, ffamily);
    
    Update_Histogram_Julesz(val, ffamily);
    
    least=energy[count][0];
    
    for(val= 0; val< ffamily->greyLevel; val++) {
      if(least>energy[count][val]) {
	least=energy[count][val];
      }
    }
    sum = 0.0;      /* shift and normalize the probability */
    for(val = 0; val < ffamily->greyLevel; val++)
      energy[count][val] -= least;
  }
  /* Now we need to figure the initial temperature and
     the tempature at 100th sweep based on the entropy setting */
  for (k1=0; k1<2; k1++) {
    Temp[k1] = controlInfo->julesz_synInitTemp*ffamily->usedfilters;
    if (k1==0) {
      desired_entropy = controlInfo->entropy_init_perc *
	(log(ffamily->greyLevel)/log(2));
    }
    else {
      desired_entropy = controlInfo->entropy_100_iter_perc *
	(log(ffamily->greyLevel)/log(2));
    }
    reduce_rate = controlInfo->julesz_synCoolingRatio;
    prev_entropy = -100.;
    do {
      /* Calculate the entropy using the current temperature */
      curr_entropy = 0;
      for (count=0; count < sweep; count++) {
	for(val=0; val<ffamily->greyLevel; val++) {
	  temp_energy[val] = energy[count][val] / Temp[k1];
	}
	
	sum = 0.0;      /* shift and normalize the probability */
	for(val = 0; val < ffamily->greyLevel; val++)
	  sum+=prob[val]=exp(0-temp_energy[val]);
	
	for( val= 0; val< ffamily->greyLevel; val++)
	  prob[val] /= sum;
	
	entropy =0.0;
	for( val= 0; val< ffamily->greyLevel; val++) {
	  /* printf("%8.6lf ",  prob[val]); */
	  dtmp = log(prob[val])/log(2);
	  if (finite(dtmp)) 
	    entropy -= prob[val] * dtmp;
	}
	/* printf("with entropy %12.10f \n", entropy); */
	curr_entropy += entropy;
      }
      curr_entropy /= sweep;
      if (fabs(curr_entropy-desired_entropy) < 
	  controlInfo->entropy_epsilon) break;
      if (fabs(curr_entropy-desired_entropy) > 
	  fabs(prev_entropy-desired_entropy)) {
	reduce_rate =1+(reduce_rate-1)/2.0 ;
      }
      printf("Previos average: %10.8lf current average: %10.8lf ",
	     prev_entropy, curr_entropy);
      printf("Current tempature %10.8f current rate: %10.8f\n",
	     Temp[k1], reduce_rate);
      /*printf("Enter a number to continue: ");
	scanf("%d", &val);
      */
      if (curr_entropy < desired_entropy) {
	Temp[k1] *= reduce_rate;
      }
      else {
	Temp[k1] /= reduce_rate;
      }
      prev_entropy = curr_entropy;
    } while(1);
  }
  
  free(temp_energy);
  free(prob);
  Free_Matrix(energy, sweep);
  printf("Initial tempature is %10.8f and ", Temp[0]);
  printf("temperature at 100th sweep is %10.8f\n", Temp[1]);
  controlInfo->julesz_synInitTemp =  Temp[0]/ffamily->usedfilters;
  controlInfo->julesz_synCoolingRatio = (float)pow((double)(Temp[0]/Temp[1]),
				     (double)0.01);
  printf("The cooling ratio is %12.10f\n",
	 controlInfo->julesz_synCoolingRatio);
 
  return;
}

int Flip_Julesz(IMAGEINT *syn, FILTERBANK *ffamily,
		CONTROL_INFO *controlInfo,
		float *average_entropy)
{
  float least, sum, r;
  int   val, i,k;
  int   old;
  int count, row, col;
  float *energy;
  double *prob;
  int  sweep;
  float energyPow;
  double entropy;
  double dtmp;
  double sum_entropy;
  int    nchanges;
  int direction;
  int updates;
  updates = 0;
  nchanges = 0;
  sweep = syn->nrow * syn->ncol;
  energyPow = controlInfo->julesz_energyPow;
  printf("Doing one sweep (regular %d) with %d updates, ",
	 controlInfo->julesz_regular,sweep);
  printf("power=%5.3f(%5.3f %5.3f)", energyPow,
	 controlInfo->julesz_powerHeatingRatio,
	 controlInfo->julesz_EndenergyPow);
  printf(", and temp=%8.4f (%d %8.4f) with cooling %8.6f....\n\t ",
	 controlInfo->synTemp, ffamily->usedfilters,
	 (float)(ffamily->usedfilters * controlInfo->synTemp),
	 controlInfo->synCoolingRatio);
  fflush(stdout);
  energy = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  prob = (double *)malloc(sizeof(double)*ffamily->greyLevel);
  sum_entropy = 0;
  
  for(count=0; count<sweep; count++) {   
    switch (controlInfo->julesz_regular) {
    case 0:
      do {
	row=(int) (Unit_Random()*syn->nrow);   
	col=(int) (Unit_Random()*syn->ncol);
      } while (row == syn->nrow || col == syn->ncol);
      break;
    case 2:
      if (count==0) {
	row = 0;
	col = 0;
      }
      else {
	row++;
	if (row == syn->nrow) {
	  row = 0;
	  col++;
	}
      }
      break;
    case 3:
      k = 0;
      if (count==0) {
	row = 0;
	col = 0;
	direction = 1;
      }
      else {
	row += direction;
	col -= direction;
	if (col == syn->ncol) {
	  row += 2;
	  col = syn->ncol-1;
	  direction = 0-direction;
	}
	else {
	  if (row == syn->nrow) {
	    row = syn->nrow -1;
	    col += 2;
	    direction = 0-direction;
	  }
	  else {
	    if (row == -1) {
	      row = 0;
	      direction = 0-direction;
	    }
	    else {
	      if (col == -1) {
		col = 0;
		direction = 0-direction;
	      }
	      else {
		k = 1;
	      }
	    }
	  }
	}
      }
      /*if (k==0) {
	printf("(%d %d %d) ", row, col, row+col);
	 fflush(stdout);
	 }*/
      break;
    case 4:
      k = 0;
      if (count==0) {
	row = 0;
	col = syn->ncol-1;
	direction = 1;
      }
      else {
	row += direction;
	col += direction;
	if (col == -1) {
	  row += 2;
	  col = 0;
	  direction = 0-direction;
	}
	else {
	  if (row == syn->nrow) {
	    row = syn->nrow -1;
	    col -= 2;
	    direction = 0-direction;
	  }
	  else {
	    if (row == -1) {
	      row = 0;
	      direction = 0-direction;
	    }
	    else {
	      if (col == syn->ncol) {
		col = syn->ncol-1;
		direction = 0-direction;
	      }
	      else {
		k = 1;
	      }
	    }
	  }
	}
      }
      /*
	printf("(%d %d %d) ", row, col, row+col);
	fflush(stdout);
      */
      break;
    default:
      if (count==0) {
	row = 0;
	col = 0;
      }
      else {
	col++;
	if (col==syn->ncol) {
	  col =0;
	  row++;
	}
      }
    }
    if ((count+1)%(sweep/10) == 0) {
      printf("%d ", count);
      fflush(stdout);
    }
    
    updates++;
    old = syn->data[row][col];
    Update_Patch_Julesz(row, col, syn, ffamily);
    
    Compute_Patch_Histogram_Julesz(ffamily);
    
    Calc_Energy_Julesz(row, col, energy, syn, ffamily, energyPow);
    for(val=0; val<ffamily->greyLevel; val++) {
      energy[val] /= (controlInfo->synTemp*ffamily->usedfilters);
    }
    
    least=energy[0];
    
    for(val= 0; val< ffamily->greyLevel; val++) {
      if(least>energy[val]) {
	least=energy[val];
      }
    }
    
    for(val = 0; val < ffamily->greyLevel; val++) {
      prob[val] = exp(-(energy[val]-least));
    }
    /* for (val=1; val < (ffamily->greyLevel-1); val++) {
       prob[val] = 0;
       }
    */
    sum = 0.0;      /* shift and normalize the probability */
    for(val = 0; val < ffamily->greyLevel; val++) {
      sum += prob[val];
    }
   
    for( val= 0; val< ffamily->greyLevel; val++)
      prob[val] /= sum;
    if (updates < 100) {
      entropy =0.0;
      if (updates == (100-1)) printf("\t ");
      for( val= 0; val< ffamily->greyLevel; val++) {
	if (updates == (100-1)) {
	  printf("%8.6lf ",  prob[val]);
	}
	dtmp = log(prob[val])/log(2);
	if (finite(dtmp)) 
	  entropy -= prob[val] * dtmp;
      }
      sum_entropy += entropy;
      if (updates == (100-1)) {
	printf("with entropy %12.10f (old value=%d) and average %12.10lf\n", 
	       entropy, old, (double)(sum_entropy/(updates)));
	*average_entropy = (float)(sum_entropy/(updates));
      }
    }
    sum=0;
    for(val=0; val< ffamily->greyLevel; val++) {
      prob[val]+=sum;
      sum=prob[val];
    }
    /** choose the pixel value by the cdf **/
    r=Unit_Random(); val = 0;
    while(r>prob[val]) val++;
    
    if( val>= ffamily->greyLevel)  
      val= ffamily->greyLevel-1;
    
    Update_Map_Julesz(row, col, val, ffamily);
    
    Update_Histogram_Julesz(val, ffamily);
    
    /*printf("val =%d \n", val);*/
    nchanges += (old != val);
    syn->data[row][col]=val;
    /*if ((count+1)%1000 ==0) {
      printf("Self testing for texture type %d\n", prevIndex);
      Self_Testing(ffamily,syn);
    }
    */
  }
  printf("DONE with %d updates and %d changes.\n", updates, nchanges);
  free(energy);
  free(prob);
  
  /* Cooling the temperature */
  controlInfo->synTemp /= controlInfo->synCoolingRatio;
  if (controlInfo->synTemp < controlInfo->synLowTemp) {
    controlInfo->synTemp = controlInfo->synLowTemp;
  }
  else {
    if (nchanges ==0) 
      nchanges = 1;
  }
  controlInfo->julesz_energyPow *= controlInfo->julesz_powerHeatingRatio;
  if (controlInfo->julesz_energyPow > controlInfo->julesz_EndenergyPow) 
    controlInfo->julesz_energyPow = controlInfo->julesz_EndenergyPow;
  return nchanges;
}


void Update_Patch_Julesz(int row, int col,
			 IMAGEINT *syn, FILTERBANK *ffamily)
{
  ARRAY  patch, kernel;
  MAT    map;
  FILTER *filter;
  int  layer_no, filter_no;   
  int   height, width;
  float diff;
  int   i,j, val, old, mid;
  int   crow, ccol;
  
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++) {
    filter=&(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    map=filter->map.data;
    kernel=filter->kernel;
    width=filter->wid; height=filter->ht;
    
    old=syn->data[row][col]; 
    mid=filter->size-1;
    
    if(row<height || row>= (syn->nrow-height) 
       || col<width || col>=(syn->ncol-width) ) {
      for(val=0; val < ffamily->greyLevel; val++) { 
	patch= filter->patch[val];
	if(val==old) {  /* the current value, and just copy */
	  for(i=0; i<filter->size; i++) {
	    crow = (row+filter->rlist[i]+syn->nrow) % 
	      syn->nrow;
	    ccol = (col + filter->clist[i]+syn->ncol) %
	     syn->ncol;
	    patch[i]=map[crow][ccol]; 
	  }
	}
	else {
	  diff=(val-old);
	  for(i=0; i<filter->size; i++) {
	    crow = (row+filter->rlist[i]+syn->nrow) % 
	      syn->nrow;
	    ccol = (col + filter->clist[i]+syn->ncol) %
	      syn->ncol;
	    patch[i]=map[crow][ccol]+
	      diff*kernel[mid-i];
	  }
	}
      }
    }
    else {   /* without checking the boundary to save time */
      for(val=0; val< ffamily->greyLevel; val++) {
	patch= filter->patch[val];
	
	if(val==old) {
	  for(i=0; i<filter->size; i++) {
	    patch[i] = map[row+filter->rlist[i]][col+filter->clist[i]];  
	  }
	}
	else {
	  diff=(val-old);
	  for(i=0; i<filter->size; i++) {
	    patch[i] = map[row+filter->rlist[i]][col+filter->clist[i]] + 
	      diff*kernel[mid-i];
	  }
	}
      } 
    }
  }
  return;
}

/***********************************************************
  
   compute the local histogram of patches

********************************************************/
void Compute_Patch_Histogram_Julesz(FILTERBANK *ffamily)
{
  FILTER  *filter;
  ARRAY  hist, patch;
  int index, val, bin, bin_num, filter_no, i;
  float  mark0;
  
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++) {
    filter= &(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    mark0=filter->mark[0]; 
    bin_num=filter->bin_num;
    
    for(val = 0 ; val< ffamily->greyLevel; val++) {
      for(bin=0; bin<bin_num; bin++) {
	filter->patch_hist[val][bin]=0;
      }
    }
    for(val=0; val< ffamily->greyLevel; val++) {
      hist=filter->patch_hist[val];
      patch=filter->patch[val];
      
      for(i=0; i<filter->size; i++) {
	index=Round((patch[i]-mark0)/(filter->unit));
	if(index<0) { 
	  index = 0;
	}
	else {
	  if(index>=bin_num) {
	    index = bin_num-1;
	  }
	}
	hist[index]+=1;
      }
    }
  }
  return;
}


/********************************************************
   Once the pixel [row][col] has been set to val
   we need to update the map of convolution by copying
     the corresponding patch into the map
*********************************************************/
void Update_Map_Julesz(int row, int col, int val,
		       FILTERBANK *ffamily)
     
{
  FILTER *filter;
  MAT    map;
  ARRAY  patch;
  int    filter_no;
  int    i;
  int    crow, ccol;
  for(filter_no=0; filter_no < ffamily->nfilter ; filter_no++) {
    filter= &(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    patch=filter->patch[val];
    map=filter->map.data;   
    for(i=0; i<filter->size; i++) {
      crow = (row+filter->rlist[i]+filter->map.nrow) % 
	filter->map.nrow;
      ccol = (col + filter->clist[i]+filter->map.ncol) %
	filter->map.ncol;
      map[crow][ccol] = patch[i]; 
    }
  }
  return;
}

/********************************************
 *
 *   Complete the histogram by adding the patch_hist[val] back
 *
 *******************************************/
void Update_Histogram_Julesz(int val, FILTERBANK *ffamily)
{
  FILTER *filter;
  int filter_no, bin;
  
  for(filter_no=0; filter_no < ffamily->nfilter; filter_no++) {
    filter= &(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    for(bin=0; bin<filter->bin_num; bin++)
      filter->hist[bin]+= filter->patch_hist[val][bin];
  }
}

/***********************************************************

  To flip the pixel[row][col] to val, we need to know the
 cond. prob.  P( val | neighbors), the new convolution
 are given in filter->patch[val-Min][][], it is independent
 of any other pixel values. so the prob can be calculated 
         directly from patch[][]
************************************************************/

void  Calc_Energy_Julesz(int row, int col, float *energy,
			 IMAGEINT *syn,
			 FILTERBANK *ffamily,
			 float energyPow)
{
  ARRAY   local_hist, target, hist;
  FILTER *filter;
  float   tmp;
  int     filter_no, bin;
  int     val, old;
  
  for(val=0; val< ffamily->greyLevel; val++) {
    energy[val]=0;
  }
  
  old=syn->data[row][col];
  /* minus the old patch_histogram first */
  for(filter_no=0; filter_no < ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    for(bin=0; bin<filter->bin_num; bin++)
      filter->hist[bin] -= filter->patch_hist[old][bin];
  }
  
  for(filter_no=0; filter_no < ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    target=filter->target_hist;
    hist=filter->hist;
    for(val=0; val< ffamily->greyLevel; val++) {
      local_hist=filter->patch_hist[val];
      for(bin=0; bin<filter->bin_num; bin++) {
	tmp= hist[bin]+local_hist[bin]-target[bin];
	energy[val] += powf(fabsf(tmp),energyPow);
      }
    }
  }
 
  return;
}
















