#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"
#include "hist-util.h"
#include "filter-util.h"
#include "hole-util.h"

int main(int argc, char **argv)
{
  char paraFile[256];
  IMAGE_DATABASE imageDataBase;
  int windex, upindex;
  int wsize;
  char prefix[256];
  char fname[256];
  int i,k;
  CONTROL_INFO  para_setting;
  FILTERBANK  fbank;
  IMAGEINT   obs_img, syn_img;
  float  total_err, max_err, weighted_err;
  FILE *errfp;
  DIGGED_HOLES holes_digged;

  holes_digged.nhole = 0;
  obs_img.nrow = 0;
  syn_img.nrow = 0;
  if (argc < 1) {
    printf("Please specify the parameter file: ");
    scanf("%s", paraFile);
  }
  else {
    strcpy(paraFile, argv[1]);
  }
  
  LoadParameter(paraFile, &para_setting);
  DisplayParameter(&para_setting);
  
  srand(para_setting.seed);

  fbank.nfilter = 0;

  imageDataBase.nimages =0;
  imageDataBase.num_ref_model =0;
  Read_Filters(para_setting.filterFile, &fbank);
  
  
  if (Load_Database(para_setting.databaseFile, &fbank,
		    &imageDataBase) != 0) {
    Create_Database(&para_setting, &fbank,
		    &imageDataBase);
    Save_Database(para_setting.databaseFile, &fbank,
		  &imageDataBase);
  }
  
  fbank.greyLevel = para_setting.greyLevel;
  
  Initialize_Obs_Pseudo(&fbank, &obs_img,
			&para_setting,
			&imageDataBase);
  
  Initialize_Syn_Satellite(&fbank, &syn_img, &para_setting);
  
  Create_Holes(&para_setting,
	       &fbank,
	       &imageDataBase,
	       &obs_img,
	       &holes_digged);
  
  Generate_Target_Hist_From_Image_WithHoles(&fbank, &obs_img,
					    &(holes_digged.hole_map));
  Initial_Synthesize_Image(&fbank, 
			   &syn_img,
			   &(holes_digged.hole_map));
  
  Scale_Target_Hist(&fbank, (float)(fbank.norm));
  
  sprintf(fname,"%s_obs.pgm", para_setting.prefix);
  Write_An_Image_Int(&obs_img, (int)(256/para_setting.greyLevel),
		     fname);
  
  sprintf(fname,"%s_syn_init.pgm", para_setting.prefix);
  Write_An_Image_Int(&syn_img, (int)(256/para_setting.greyLevel),
		     fname);
 
  for (i=0; i <= para_setting.learningIter; i+= para_setting.learningUpdate) {
    Generate_Hist_Frame_Holes(&para_setting,
			      &fbank,
			      &holes_digged,
			      &obs_img,
			      &syn_img);
    printf("Updating lambdas ... \n");
    sprintf(fname,"%s_frame_hole_Histogram.dat", para_setting.prefix);
    total_err = Update_Lambda(i,fname, 
			      &fbank,
			      &para_setting,
			      &max_err,
			      &weighted_err);
    Save_Lambda_To_File(&fbank,
			para_setting.lambdaFile);
    sprintf(fname,"%s_Err.dat", para_setting.prefix);
    if (i==0) {
      errfp = fopen(fname,"wb");
    }
    else {
      errfp = fopen(fname,"ab");
    }
    fprintf(errfp,"%d with max_error = %8.6f ", i, max_err);
    fprintf(errfp,"weighted error: ");
    fprintf(errfp,"%8.6f ", weighted_err);
    fprintf(errfp,"Total = %8.6f \n", total_err);
    fclose(errfp);
    if ( (i%para_setting.saveSynIter) ==0) {
      sprintf(fname,"%s_learning_syn_%d.pgm", para_setting.prefix,i);
      Write_An_Image_Int(&syn_img, (int)(256/para_setting.greyLevel),
                         fname);
      
    }
    
    if (max_err < para_setting.learningMaxErrEpsilon) break;
  }
  

  Free_Holes(&holes_digged);
  Free_Image_Int(&obs_img);
  Free_Image_Int(&syn_img);
  Free_Filter_Bank(&fbank);
  Free_Database(&imageDataBase);
  return 0;
}














