#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"
#include "hist-util.h"
#include "filter-util.h"
#include "julesz-util.h"

int main(int argc, char **argv)
{
  int windex, upindex;
  int wsize;
  char obsName[256], outputName[256];
  int  low, high; 
  int i,k;
  CONTROL_INFO  para_setting;
  FILTERBANK  fbank;
  IMAGEINT   obs_img, syn_img;
  float  total_err, max_err, weighted_err;
  float total_err_sum;
  int   total_err_times;
  FILE *errfp;
  int greyLevel;
  float tailPerc;
  
  obs_img.nrow = 0;
  syn_img.nrow = 0;
  if (argc < 2) {
    printf("Please specify original image: ");
    scanf("%s", obsName);
  }
  else {
    strcpy(obsName, argv[1]);
  }

  if (argc < 3) {
    printf("Please specify original image: ");
    scanf("%s", outputName);
  }
  else {
    strcpy(outputName, argv[2]);
  }
  if (argc < 4) {
    greyLevel = 8;
  }
  else {
    greyLevel = atoi(argv[3]);
  }
  if (argc < 5) {
    tailPerc = 0.5 / (float)greyLevel;
  }
  else {
    sscanf(argv[4],"%f", &tailPerc);
  }
  Read_An_Image_Int(obsName, &obs_img);
  Normalize_Image_Matrix(obs_img.data, obs_img.nrow, obs_img.ncol,
			 greyLevel, tailPerc);
  
  Write_An_Image_Int(&obs_img, (int)(256/greyLevel),
		     outputName);
  Free_Image_Int(&obs_img);
 
  return 0;
}














