#define  PARA_UTIL_SOURCE_CODE
#include "para-util.h"

void SetDefaultParameter(CONTROL_INFO *controlInfo)
{
  /* Set file names to be null initially */
  controlInfo->inputFile[0] = '\0';
  controlInfo->filterFile[0] = '\0';
  controlInfo->prefix[0] = '\0';
  controlInfo->histMark[0] = '\0';
  controlInfo->databaseFile[0] = '\0';
  controlInfo->lambdaFile[0] = '\0';
  controlInfo->truelambdaFile[0] = '\0';
  controlInfo->backlambdaFile[0] = '\0';
  controlInfo->frontlambdaFile[0] = '\0';

  controlInfo->lammda = 1000.;
  controlInfo->topWin = 20-1;
  controlInfo->segWin = 10;
  controlInfo->npoint = 0;
  controlInfo->boundWeight = 0.1;
  controlInfo->refinedWin = 0;
  controlInfo->interactive = 0;
  controlInfo->seed = 517;
  controlInfo->expected_Group = 7;
  controlInfo->seedWin = controlInfo->segWin + 2;
  controlInfo->seedGrid = 5;
  controlInfo->nInput = 0;
  controlInfo->greyLevel = 8;
  controlInfo->syn_height = 128;
  controlInfo->syn_width = 128;
  controlInfo->initialSyntype[0] = 'n';
  controlInfo->initialSynval = 0;
  controlInfo->learningIter = 2000;
  controlInfo->learningAlpha = 2.;
  controlInfo->learningUpdate = 10;
  controlInfo->learningMaxErrEpsilon = 0.025;
  controlInfo->saveSynIter = 20;
  controlInfo->synStartIter = 0;
  controlInfo->synInitTemp = 3.0;
  controlInfo->synLowTemp = 1.0;
  controlInfo->synCoolingRatio = 1.005;
  controlInfo->synIter = 2000;
  controlInfo->synErrIter = 20;
  controlInfo->synMaxErrEpsilon = 0.025;
  /* satellite learning algorithm */
  controlInfo->model_too_close = 0.05;
  controlInfo->num_ref_model = 0;
  controlInfo->hole_syn_init_iter = 0;
  controlInfo->hole_total_syn = 10;
  controlInfo->overlapped_holes = 1;
  controlInfo->include_observed = 1;

  controlInfo->holes_regular = 0;
  controlInfo->holes_need_patch_hist = 0;
  controlInfo->holes_need_hist_vector = 1;
  controlInfo->chosen_manually = 0;
  controlInfo->lambdaIter = 20;

  /* KL distance between textures */
  controlInfo->texture_KL_num_samples = 1;

  /* For julesz sampling */
  controlInfo->julesz_synInitTemp = 400.;
  controlInfo->julesz_synLowTemp = 1.0;
  controlInfo->julesz_synCoolingRatio = 1.05;
  controlInfo->julesz_InitenergyPow = 1.0;
  controlInfo->julesz_EndenergyPow = 4.0;
  controlInfo->julesz_powerHeatingRatio = 1.0;

  controlInfo->julesz_regular = 0;
  controlInfo->julesz_mark_file[0] = '\0';
  controlInfo->julesz_mark_init[0] = '\0';
  controlInfo->julesz_mark_init_scale = 1;
  controlInfo->julesz_seq = 10000;
  controlInfo->julesz_start_seq = 0;

  controlInfo->use_analytical_form = 0;
  controlInfo->shift_hist_percent = 1.0;
  controlInfo->accept_chi_threshold = 1000.;
  controlInfo->entropy_num = 0;
  controlInfo->tail_factor = 1.0;
  controlInfo->object_center_nrow = 1;
  controlInfo->object_center_ncol = 1;
  controlInfo->object_border_nrow = 2;
  controlInfo->object_border_ncol = 2;
  return;
}

void DisplayParameter(CONTROL_INFO *controlInfo)
{
  int i,j,wsize;
  printf("\nNow Parameters are set as follows.\n");
  printf("\tInput texture Image:\t%s\n", controlInfo->inputFile);
  printf("\tOutput File Prefix:\t%s\n", controlInfo->prefix);
  printf("\tDatabase file: \t%s.\n", controlInfo->databaseFile);
  if (controlInfo->histMark[0] == '\0' ) {
    printf("\tHistogram marks will be computed.\n");
  }
  else {
    printf("\tHistogram mark file:\t%s\n", controlInfo->histMark);
  }
  
  printf("\tHomogenous texture region detection parameters.\n");
  printf("\t\tHomogeonous texture detection top win: %d\n",
	 controlInfo->seedWin+1);
   printf("\t\t\ttexture detection bottom win: %d\n",
	  controlInfo->segWin+1);
  printf("\t\tHomogenous texture detection grid size: %d\n",
	 controlInfo->seedGrid);
  printf("\t\tRoughly expected groups: %d\n",
	 controlInfo->expected_Group);
  printf("\t\tSame layer difference weight: %6.4f\n",
	 controlInfo->sameLayerWeight);
  printf("\t\tDistance between selected groups %6.4f\n",
	 controlInfo->crossDistWeight);
  printf("\t\tHomogenous distance threshold: %6.4f\n",
	 controlInfo->groupHomoThreshold);
  
  printf("\tThere are %d texture images to be searched.\n",
	 controlInfo->nInput);
  for (i=0; i < controlInfo->nInput; i++) {
    printf("\t\t%3d\t%s %s\n", i, 
	   controlInfo->inputFiles[i],
	   controlInfo->inputType[i]);
  }
  
  if (controlInfo->interactive) {
    printf("\tPrompt for checking intermediate region boundaries.\n");
  }
  else {
    printf("\tProgram will run continuosly until finished.\n");
  }
  printf("\tSeed for random number generator:  %d\n",
	 controlInfo->seed);
  if (controlInfo->use_analytical_form) {
    printf("\tHistograms based on p and c values will be used ");
    printf("if possible.\n");
  }
  printf("End of Parameters.\n\n");
  return;
}
  
int LoadParameter(char *fName,CONTROL_INFO *controlInfo)
{
  char string[MAXFILENAME], opt[MAXFILENAME];
  FILE *fp;
  int i, tmp;
  SetDefaultParameter(controlInfo);
  if ( (fp = fopen(fName,"rb")) == NULL) return -1;
  /* reading all parameters */
  while(fscanf(fp,"%s",string) >0) {
    if (string[0] =='#')  {
      /* it is a comment */
      while (getc(fp) != '\n');
      continue;
    }
    if (strcasecmp(string,"input-image") == 0) {
      fscanf(fp,"%s",controlInfo->inputFile);
      continue;
    }
    if (strcasecmp(string,"filter-file") == 0) {
      fscanf(fp,"%s",controlInfo->filterFile);
      continue;
    }
    
    if (strcasecmp(string,"output-prefix") == 0) {
      fscanf(fp,"%s",controlInfo->prefix);
      continue;
    }
    
    if (strcasecmp(string,"hist-mark-file") == 0) {
      fscanf(fp,"%s",controlInfo->histMark);
      continue;
    } 
    if (strcasecmp(string,"lambda-file") == 0) {
      fscanf(fp,"%s",controlInfo->lambdaFile);
      continue;
    }  
    if (strcasecmp(string,"true-lambda-file") == 0) {
      fscanf(fp,"%s",controlInfo->truelambdaFile);
      continue;
    }  
    if (strcasecmp(string,"database-file")==0) {
      fscanf(fp,"%s",controlInfo->databaseFile);
      continue;
    } 
    if (strcasecmp(string,"synthesis-flags")==0) {
      fscanf(fp,"%d",&(controlInfo->use_analytical_form));
      if (controlInfo->use_analytical_form!= 0) {
	fscanf(fp,"%f%f", &(controlInfo->shift_hist_percent),
	       &(controlInfo->accept_chi_threshold));
      }
      continue;
    }  
    if (strcasecmp(string,"bound-term") == 0) {
      fscanf(fp,"%f",&(controlInfo->boundWeight));
      if (controlInfo->boundWeight > 1.0 || controlInfo->boundWeight < 0.0)
	controlInfo->boundWeight = 0.1;
      
      continue;
    } 
    if (strcasecmp(string,"top-window") == 0) {
      fscanf(fp,"%d",&(controlInfo->topWin));
      controlInfo->topWin--;
      continue;
    }
    if (strcasecmp(string,"seg-window") == 0) {
      fscanf(fp,"%d",&(controlInfo->segWin));
      controlInfo->segWin--;
      continue;
    }
    if (strcasecmp(string,"use-refine-win") == 0) {
      fscanf(fp,"%d",&(controlInfo->refinedWin));
      continue;
    }
    if (strcasecmp(string,"seed")==0) {
      fscanf(fp,"%d",&(controlInfo->seed));
      continue;
    }
    if (strcasecmp(string,"greylevel") ==0) {
      fscanf(fp,"%d",&(controlInfo->greyLevel));
      continue;
    }
    if (strcasecmp(string,"synthesize-image") == 0) {
      fscanf(fp,"%d%d", &(controlInfo->syn_height),
	     &(controlInfo->syn_width));
      fscanf(fp,"%s%d", controlInfo->initialSyntype,
	     &(controlInfo->initialSynval));
      continue;
    }
    if (strcasecmp(string,"learning-para")==0) {
      fscanf(fp,"%d%d%f", &(controlInfo->learningIter),
	     &(controlInfo->learningUpdate),
	     &(controlInfo->learningMaxErrEpsilon));
      fscanf(fp,"%f",&(controlInfo->learningAlpha));
      continue;
    }
    if (strcasecmp(string,"synthesize-para")==0) {
      fscanf(fp,"%f%f%d%d%f%d", &(controlInfo->synInitTemp),
	     &(controlInfo->synCoolingRatio),
	     &(controlInfo->synIter),
	     &(controlInfo->synErrIter),
	     &(controlInfo->synMaxErrEpsilon),
	     &(controlInfo->synStartIter));
      continue;
    }
    if (strcasecmp(string,"object-para")==0) {
      fscanf(fp,"%d%d%d%d", 
	     &(controlInfo->object_center_nrow),
	     &(controlInfo->object_center_ncol),
	     &(controlInfo->object_border_nrow),
	     &(controlInfo->object_border_ncol));
        continue;
    }
    if (strcasecmp(string,"julesz-para")==0) {
      fscanf(fp,"%f%f%f%f%d%f%f", &(controlInfo->julesz_synInitTemp),
	     &(controlInfo->julesz_synCoolingRatio),
	     &(controlInfo->julesz_synLowTemp),
	     &(controlInfo->julesz_InitenergyPow),
	     &(controlInfo->julesz_regular),
	     &(controlInfo->julesz_powerHeatingRatio),
	     &(controlInfo->julesz_EndenergyPow));
      continue;
    }
    if (strcasecmp(string,"julesz-seq-para")==0) {
      fscanf(fp,"%d%d", &(controlInfo->julesz_seq),
	     &(controlInfo->julesz_start_seq));
      continue;
    }
    if (strcasecmp(string,"julesz-mask-para")==0) {
      fscanf(fp,"%s%s%d", controlInfo->julesz_mark_file,
	     controlInfo->julesz_mark_init,
	     &(controlInfo->julesz_mark_init_scale));
      continue;
    }
    if (strcasecmp(string,"tail-para") ==0) {
      fscanf(fp,"%f%f", &(controlInfo->tail_factor),
	     &(controlInfo->tail_epsilon));
      continue;
    }
    if (strcasecmp(string,"julesz-entropy-para")==0) {
      fscanf(fp,"%d%f%f%f", &(controlInfo->entropy_num),
	     &(controlInfo->entropy_init_perc),
	     &(controlInfo->entropy_100_iter_perc),
	     &(controlInfo->entropy_epsilon));
      continue;
    }
    if (strcasecmp(string,"synthesize-low-temp")==0) {
      fscanf(fp,"%f", &(controlInfo->synLowTemp));
      continue;
    }
    if (strcasecmp(string,"satellite-para")==0) {
      fscanf(fp,"%d%f%d%d%d%d", &(controlInfo->num_ref_model),
	     &(controlInfo->model_too_close),
	     &(controlInfo->num_of_holes),
	     &(controlInfo->hole_size),
	     &(controlInfo->overlapped_holes),
	     &(controlInfo->include_observed));
      controlInfo->chosen_manually = 0;
      continue;
    }
    
    if (strcasecmp(string,"satellite-models")==0) {
      fscanf(fp,"%d", &(controlInfo->num_ref_model));
      for (i=0; i < controlInfo->num_ref_model; i++) {
	fscanf(fp,"%d", 
	       &(controlInfo->chosen_ref_models[i]));
      }
      controlInfo->chosen_manually = 1;
    }

    if (strcasecmp(string,"hole-para")==0) {
      fscanf(fp,"%d%d%d",
	     &(controlInfo->hole_syn_init_iter),
	     &(controlInfo->hole_syn_every_iter),
	     &(controlInfo->hole_total_syn));
      continue;
    }
    if (strcasecmp(string,"hole-add-para")==0) {
      fscanf(fp,"%d%d%d",
	     &(controlInfo->holes_regular),
	     &(controlInfo->holes_need_patch_hist),
	     &(controlInfo->holes_need_hist_vector));
      continue;
    }
    if (strcasecmp(string,"output-para")==0) {
      fscanf(fp,"%d%d",
	     &(controlInfo->saveSynIter),
	     &(controlInfo->saveHistogram));
      continue;
    }
    if (strcasecmp(string,"lambda-iter")==0) {
      fscanf(fp,"%d", &(controlInfo->lambdaIter));
      continue;
    }
    if (strcasecmp(string,"interactive") == 0) {
      fscanf(fp,"%d",&(controlInfo->interactive));
      continue;
    }
    if (strcasecmp(string,"rand-seed") == 0) {
      fscanf(fp,"%d",&(controlInfo->seed));
      continue;
    } 
    if (strcasecmp(string,"seed-pixel-para") ==0) {
      fscanf(fp,"%d%d%d%f%f%f",&(controlInfo->seedWin),
	     &(controlInfo->seedGrid),
	     &(controlInfo->expected_Group),
	     &(controlInfo->sameLayerWeight),
	     &(controlInfo->crossDistWeight),
	     &(controlInfo->groupHomoThreshold));
      controlInfo->seedWin --;
      continue;
    }

    if (strcasecmp(string,"texture-KL-para")==0) {
      fscanf(fp, "%s%s",
	     controlInfo->backlambdaFile,
	     controlInfo->frontlambdaFile);
      fscanf(fp, "%d",
	     &(controlInfo->texture_KL_num_samples));
      continue;
    }
    
    if (strcasecmp(string,"input-texture")==0) {
      fscanf(fp, "%d", &(controlInfo->nInput));
      for (i=0; i < controlInfo->nInput; i++) {
	if (i < MAX_TEXTURE_INPUT) {
	  fscanf(fp,"%s", controlInfo->inputFiles[i]);
	  fscanf(fp,"%s", controlInfo->lambdaFiles[i]);
	  fscanf(fp,"%s", controlInfo->synFiles[i]);
	}
	else {
	  fscanf(fp,"%s", opt);
	  fscanf(fp,"%s", opt);
	  fscanf(fp,"%s", opt);
	}
      }
      if (controlInfo->nInput > MAX_TEXTURE_INPUT) {
	printf("Too many input texture images. ");
	printf("Only the first %d will be used.\n", MAX_TEXTURE_INPUT);
	controlInfo->nInput = MAX_TEXTURE_INPUT;
      }
      continue;
    }
    
    if (strcasecmp(string,"seed-points") == 0) {
      fscanf(fp,"%d",&(controlInfo->npoint));
      for (i=0; i < controlInfo->npoint; i++) {
	if (i < MAX_LABEL_IMAGE) {
	  fscanf(fp,"%d%d", 
		 &(controlInfo->seedPoints[i].x),
		 &(controlInfo->seedPoints[i].y));
	}
	else {
	  fscanf(fp,"%d%d",&tmp, &tmp);
	}
      }
      if (controlInfo->npoint > MAX_LABEL_IMAGE) {
	printf(" Too many seed points. Only the first %d will be used.\n",
	       MAX_LABEL_IMAGE);
	controlInfo->npoint = MAX_LABEL_IMAGE;
      }
      continue;
    }
    
    printf("\nInvalid choice: %s\n",string);
    while (getc(fp) !='\n');
  }
  fclose(fp);
 
  if (controlInfo->prefix[0] == '\0') {
    sprintf(controlInfo->prefix,"%s_%s",controlInfo->inputFile,
	    controlInfo->filterFile);
  }
  if (controlInfo->lambdaFile[0] == '\0') {
    sprintf(controlInfo->lambdaFile,
	    "%s_lambda.dat", controlInfo->prefix);
  }
  controlInfo->synTemp = controlInfo->synInitTemp;
  if (controlInfo->include_observed !=0)
    controlInfo->include_observed = 1;
  if (controlInfo->total_Err_avg_iter ==0)
    controlInfo->total_Err_avg_iter = controlInfo->synIter-400;
  return 0;
}

