#if !defined(REGION_EXTRACT_H_H)
#define  REGION_EXTRACT_H_H
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "functions.h"
#include "imageio.h"

#if defined(REGION_EXTRACT_SOURCE_C_C)
extern POINT2D Neighbor_Table[];

#define SMALL_REGION_TEMP_LABEL (MAX_LABEL_IMAGE+1)
#define BIG_REGION_TEMP_LABEL (MAX_LABEL_IMAGE+2)
#define  HOLE_REGION_TEMP_LABEL  (MAX_LABEL_IMAGE+1)

#if !defined(NOT_CALC_VALUE_DEFAULT)
#define NOT_CALC_VALUE_DEFAULT          10.
#endif


#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif
EXTERN_FLAG void  ScanLineGrowing(int crow, int ccol,
				  REGION_LABEL *regLabels,
				  IMAGEINT *labelim,
				  float gThresh,
				  int new_label,
				  int *regSize);
EXTERN_FLAG void  ReLabel_Region(int crow, int ccol,
				 int old_label,
				 int new_label,
				 IMAGEINT *labelim,
				 int *regSize);

EXTERN_FLAG int Extract_OneRegion(REGION_LABEL *regLabels,
				  IMAGEINT *labelim,
				  float gThresh,
				  int new_label,
				  int regThres);

EXTERN_FLAG  int Remove_Small_Holes(REGION_LABEL *regLabels,
				    IMAGEINT *labelim);

EXTERN_FLAG float Check_Calc(int row, int col, REGION_LABEL *regLabels,
			     int trylabel,
			     IMAGEINT *labelim,
			     IMAGEINT *animage,
			     FILTERBANK *ffamily,
			     float *classThreshold);

EXTERN_FLAG float  Check_Calc_Threshold(int row, int col, 
					REGION_LABEL *regLabels,
					int trylabel,
					IMAGEINT *labelim,
					IMAGEINT *animage,
					FILTERBANK *ffamily);

EXTERN_FLAG float  Check_Calc_Threshold_Cross(int row, int col, 
					      REGION_LABEL *regLabels,
					      int trylabel,
					      int crosslabel,
					      IMAGEINT *labelim,
					      IMAGEINT *animage,
					      FILTERBANK *ffamily);

EXTERN_FLAG float  Check_Calc_Threshold_Cross_Orient(int row, int col, 
					 REGION_LABEL *regLabels,
					 int trylabel,
					 int crosslabel,
					 int local_orient,
					 IMAGEINT *labelim,
					 IMAGEINT *animage,
					 FILTERBANK *ffamily);

EXTERN_FLAG float  Check_Calc_With_Window(int row, int col, 
					  REGION_LABEL *regLabels,
					  int trylabel,
					  IMAGEINT *labelim,
					  IMAGEINT *animage,
					  FILTERBANK *ffamily,
					  int       local_win,
					  float *classThreshold);

EXTERN_FLAG int Refine_Bound_Point(int row1, int col1,
				   int row2, int col2,
				   REGION_LABEL *regLabels,
				   IMAGEINT *labelim,
				   IMAGEINT *animage,
				   FILTERBANK *ffamily,
				   CONTROL_INFO *controlInfo);

EXTERN_FLAG int Refine_Bound_Point_Cross(int row1, int col1,
					 int row2, int col2,
					 int  local_orient,
					 REGION_LABEL *regLabels,
					 IMAGEINT *labelim,
					 IMAGEINT *animage,
					 FILTERBANK *ffamily,
					 CONTROL_INFO *controlInfo);

EXTERN_FLAG int Refine_Bound_Point1(int row1, int col1,
				   int row2, int col2,
				   REGION_LABEL *regLabels,
				   IMAGEINT *labelim,
				   IMAGEINT *animage,
				   FILTERBANK *ffamily,
				   CONTROL_INFO *controlInfo);

EXTERN_FLAG int Refine_Region_Boundary(REGION_LABEL *regLabels,
				       int tLabels,
				       IMAGEINT *labelim,
				       IMAGEINT *animage,
				       FILTERBANK *ffamily,
				       CONTROL_INFO *controlInfo);
EXTERN_FLAG  float  Check_Check_Calc(int row, int col, 
				     REGION_LABEL *regLabels,
				     int trylabel,
				     IMAGEINT *labelim,
				     IMAGEINT *animage,
				     FILTERBANK *ffamily,
				     float *classThreshold);
EXTERN_FLAG  int Check_Refine_Bound_Point(int row1, int col1,
					  int row2, int col2,
					  REGION_LABEL *regLabels,
					  IMAGEINT *labelim,
					  IMAGEINT *animage,
					  FILTERBANK *ffamily,
					  CONTROL_INFO *controlInfo);
EXTERN_FLAG  int Check_Boundary_Pixels(REGION_LABEL *regLabels,
				       int tLabels,
				       IMAGEINT *labelim,
				       IMAGEINT *animage,
				       FILTERBANK *ffamily,
				       CONTROL_INFO *controlInfo);

EXTERN_FLAG int Check_Refine_Bound_Row(int row, int upDown,
				       int scol, int ecol,
				       int L1, int L2,
				       REGION_LABEL *regLabels,
				       IMAGEINT *labelim,
				       IMAGEINT *animage,
				       FILTERBANK *ffamily,
				       CONTROL_INFO *controlInfo);

EXTERN_FLAG int Check_Refine_Bound_Col(int col, int leftRight,
				       int srow, int erow,
				       int L1, int L2,
				       REGION_LABEL *regLabels,
				       IMAGEINT *labelim,
				       IMAGEINT *animage,
				       FILTERBANK *ffamily,
				       CONTROL_INFO *controlInfo);

EXTERN_FLAG int Check_Boundary_Rows(REGION_LABEL *regLabels,
				    int tLabels,
				    IMAGEINT *labelim,
				    IMAGEINT *animage,
				    FILTERBANK *ffamily,
				    CONTROL_INFO *controlInfo);
/*
EXTERN_FLAG  ;
*/
#undef  EXTERN_FLAG
#endif



