#define SMOOTHING_SOURCE_C_C

#include "smoothing.h"

/* Neighborhood system */
POINT2D Neighbor_Table[] = {
  {0,1},   /* 0 */
 
  {1,0},   /* 2 */

  {1,1},   /* 1 */

  {1,-1},  /* 3 */

  {0,-1},  /* 4 */
  {-1,-1}, /* 5 */
  {-1,0},  /* 6 */
  {-1,+1}, /* 7 */
  {0,0}    /* 8 */
};

#define UPDATE_LAMMDA        0.2
#define UPDATE_DIVERGE_THRESHOLD  1.0

void NonLinearSmooth_ImageVector(IMAGEVECTOR *featureImg,
				 int wsize,
				 FILTERBANK *ffamily)
{
  int i, j, k;
  int max_row, max_col;
  int crow, ccol;
  int best_row, best_col;
  float bestDist;
  float tmp;
 
  float w_11, w_12;
 
  
  w_11 = UPDATE_LAMMDA;
  w_12 = 1.0-UPDATE_LAMMDA;
  
  max_row = featureImg->nrow -1;
  max_col = featureImg->ncol -1;
  printf("Now perform smoothing with window size: %d .... ", wsize);
  fflush(stdout);
  for (i=0; i <= max_row; i++) {
    for (j=0; j <= max_col; j++) {
      bestDist = 10000.;
      for (k=0; k < 8; k+=2) {
	ccol = j + Neighbor_Table[k].x * wsize;
	crow = i + Neighbor_Table[k].y * wsize;
	if ( (ccol < 0 || ccol > max_col) &&
	     (crow < 0 || crow > max_row)) {
	  continue;
	}
	if (ccol < 0)
	  ccol = 0;
	if (ccol > max_col)
	  ccol = max_col;
	if (crow < 0)
	  crow = 0;
	if (crow > max_row)
	  crow = max_row;
	tmp = Calc_Hist_Divergence(featureImg->data[i][j],
				   featureImg->data[crow][ccol],
				   ffamily->totalBin);
	if (bestDist > tmp) {
	  bestDist = tmp;
	  best_row = crow;
	  best_col = ccol;
	}
      }
      if (bestDist < UPDATE_DIVERGE_THRESHOLD) {
	/* Update the feature vector */
	for (k=0; k < ffamily->totalBin; k++) { 
	  featureImg->data[i][j][k] = w_11 * featureImg->data[i][j][k] +
	    w_12 * featureImg->data[best_row][best_col][k];
	}
      }
    }
  }
  printf("Done!\n");
  return;
}



void Extract_Homogeous_Region(IMAGEVECTOR *featureImg,
			      int wsize,
			      FILTERBANK *ffamily,
			      IMAGEFLOAT *homoImg)
{
  int i, j, k;
  int max_row, max_col;
  int crow, ccol;
  int best_row, best_col;
  float bestDist;
  float tmp;

  max_row = featureImg->nrow -1;
  max_col = featureImg->ncol -1;
  printf("Now extracting homogenous measure with window size: %d .... ", 
	 wsize);
  fflush(stdout);
  for (i=0; i <= max_row; i++) {
    for (j=0; j <= max_col; j++) {
      bestDist = 10000.;
      for (k=0; k < 8; k++) {
	ccol = j + Neighbor_Table[k].x * wsize;
	crow = i + Neighbor_Table[k].y * wsize;
	if ( (ccol < 0 || ccol > max_col) &&
	     (crow < 0 || crow > max_row)) {
	  continue;
	}
	if (ccol < 0)
	  ccol = 0;
	if (ccol > max_col)
	  ccol = max_col;
	if (crow < 0)
	  crow = 0;
	if (crow > max_row)
	  crow = max_row;
	tmp = Calc_Hist_Divergence(featureImg->data[i][j],
				   featureImg->data[crow][ccol],
				   ffamily->totalBin);
	if (bestDist > tmp) {
	  bestDist = tmp;
	  best_row = crow;
	  best_col = ccol;
	}
      }
      homoImg->data[i][j] =
	bestDist;
      
    }
  }
  printf("Done!\n");
  return;
}




