#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"
#include "hist-util.h"
#include "filter-util.h"
#include "julesz-util.h"

int main(int argc, char **argv)
{
  char paraFile[256];
  IMAGE_DATABASE imageDataBase;
  int windex, upindex;
  int wsize;
  char prefix[256];
  char fname[256];
  int i,j,k, ii,kk;
  CONTROL_INFO  para_setting;
  FILTERBANK  fbank;
  IMAGEINT   obs_img, syn_img;
  IMAGEINT   mask_img, mask_init;
  float  total_err, max_err, weighted_err;
  float total_err_sum;
  int   total_err_times;
  FILE *errfp;
  int   seq_no;
  float   average_entropy;
  
  time_t start_t;
  
  /* Note: Each main program should include the following 
     piece of code so that we can keep track of programs and results 
     easily by looking at the script file as there are many
     different programs under different directories with the same name.
  */
  time(&start_t);
  printf("Running the following command on %s", ctime(&start_t));
  printf("from %s ", getcwd((void *)NULL, (int)0));
  if (getenv("HOSTNAME") != NULL) {
    printf("on %s ", getenv("HOSTNAME"));
  }
  else {
    if (getenv("HOST") != NULL) {
      printf("on %s ", getenv("HOST"));
    }
  }
  printf("\n");

  for (i=0; i < argc; i++) {
    printf("%s ", argv[i]);
  }
  printf("\n\n");

  obs_img.nrow = 0;
  syn_img.nrow = 0;
  mask_img.nrow = 0;
  mask_init.nrow = 0;
  if (argc < 1) {
    printf("Please specify the parameter file: ");
    scanf("%s", paraFile);
  }
  else {
    strcpy(paraFile, argv[1]);
  }
  
  LoadParameter(paraFile, &para_setting);
  DisplayParameter(&para_setting);
  
  srand(para_setting.seed);

  fbank.nfilter = 0;

  imageDataBase.nimages =0;
  Read_Filters(para_setting.filterFile, &fbank);
  
  
  if (Load_Database(para_setting.databaseFile, &fbank,
		    &imageDataBase) != 0) {
    Create_Database(&para_setting, &fbank,
		    &imageDataBase);
    Save_Database(para_setting.databaseFile, &fbank,
		  &imageDataBase);
  }

  Save_Filter_Marks(para_setting.histMark,
		    &fbank);
  Initialize_Obs_Analytical(&fbank, &obs_img,
			    &para_setting);
  sprintf(fname,"%s_obs.pgm", para_setting.prefix);
  Write_An_Image_Int(&obs_img, (int)(256/para_setting.greyLevel),
		     fname);
  Initialize_Syn(&fbank, &syn_img, &para_setting);

  Scale_Target_Hist(&fbank, (float)(fbank.norm));

  
  if (para_setting.julesz_mark_file[0] == '\0') {
    mask_img.nrow = 0;
    mask_img.ncol = 0;
  }
  else {
    Read_An_Image_Int(para_setting.julesz_mark_file, &mask_img);
    if (mask_img.nrow ==0) {
      Create_An_Image_Int(syn_img.nrow, syn_img.ncol, &mask_img);
      Init_An_Image_Int(&mask_img, (int)0);
    }
    else {
      Read_An_Image_Int(para_setting.julesz_mark_init, &mask_init);
      printf("Init mask values loaded from '%s'.\n",
	     para_setting.julesz_mark_init);
      sprintf(fname,"%s_syn_mask_init.pgm",  para_setting.prefix);
      Write_An_Image_Int(&mask_init, (int)1, fname);
      for (i=0; i < mask_img.nrow; i++) {
	for (j=0; j <  mask_img.ncol; j++) {
	  if ( (i < mask_init.nrow) && (j < mask_init.ncol) &&
	       (i < syn_img.nrow) && (j <  syn_img.ncol)) {
	    if (mask_img.data[i][j] != 0) {
	      syn_img.data[i][j] = mask_init.data[i][j] /
		para_setting.julesz_mark_init_scale;
	    }
	  }
	}
      }
      Free_Image_Int(&mask_init);
    }
    sprintf(fname,"%s_syn_mask.pgm",  para_setting.prefix);
    Write_An_Image_Int(&mask_img, (int)1, fname);
  }
  
  sprintf(fname,"%s_syn_init.pgm", para_setting.prefix);
  Write_An_Image_Int(&syn_img, (int)(256/para_setting.greyLevel),
		     fname);

  /* Force not to change lambda's */
  para_setting.learningAlpha = 0.0;
  
  /* Calc_Julesz_Temp_BasedOn_Entropy(&syn_img, &fbank, &para_setting);
   */
  /* Copy the parameter valuse for julesz */
  i = para_setting.synStartIter;
  for (seq_no=para_setting.julesz_start_seq; 
       seq_no < para_setting.julesz_seq; seq_no++) {
    Update_Syn_Filters(&fbank, &syn_img);
    Generate_Hist_From_Map(&fbank);
    para_setting.julesz_energyPow = para_setting.julesz_InitenergyPow;
    para_setting.synInitTemp = para_setting.julesz_synInitTemp;
    para_setting.synCoolingRatio =  para_setting.julesz_synCoolingRatio;
    para_setting.synLowTemp = para_setting.julesz_synLowTemp;
    para_setting.synTemp = para_setting.synInitTemp;
    for (k=0; k < para_setting.synStartIter; k++) {
      para_setting.synTemp /= para_setting.synCoolingRatio;
      if (para_setting.synTemp < para_setting.synLowTemp) 
	para_setting.synTemp = para_setting.synLowTemp;
    }
    ii = 0;
    while(1) {
      kk = Flip_Julesz(&syn_img, &fbank, &para_setting, &average_entropy);
      if ( (ii%para_setting.synErrIter) ==0) {
	Update_Syn_Filters(&fbank, &syn_img);
	Generate_Hist_From_Map(&fbank);
	printf("Calculating errors ... \n");
	sprintf(fname,"%s_julesz_syn_Histogram.dat", para_setting.prefix);
	total_err = Update_Lambda(i,fname, 
				  &fbank,
				  &para_setting,
				  &max_err,
				  &weighted_err);
        sprintf(fname,"%s_julesz_syn_Err.dat", para_setting.prefix);
        if (i==0) {
	  errfp = fopen(fname,"wb");
        }
        else {
	  errfp = fopen(fname,"ab");
        }
        fprintf(errfp,"%d with max_error = %8.6f ", i, max_err);
        fprintf(errfp,"weighted error: ");
        fprintf(errfp,"%8.6f ", weighted_err);
        fprintf(errfp,"Total = %8.6f \n", total_err);
        fclose(errfp);
        if (max_err < para_setting.synMaxErrEpsilon) {
	  i++;
	  break;
	}
      } 
      if ( (i%para_setting.saveSynIter) ==0) {
	sprintf(fname,"%s_julesz_syn_%d.pgm", para_setting.prefix,i);
	Write_An_Image_Int(&syn_img, (int)(256/para_setting.greyLevel),
			   fname);
      }
      ii++;
      i++;
      if (ii > para_setting.synIter) break;
      if (kk < 1 && average_entropy < 0.000001) {
	break;
      }
    }
    
    sprintf(fname,"%s_julesz_syn_seq_%d.pgm", para_setting.prefix,seq_no);
    Write_An_Image_Int(&syn_img, (int)(256/para_setting.greyLevel),
		       fname);
    printf("Generated %d / %d images.\n", seq_no+1,
	   para_setting.julesz_seq);
  }
  Free_Image_Int(&mask_img);
  Free_Image_Int(&obs_img);
  Free_Image_Int(&syn_img);
  Free_Filter_Bank(&fbank);
  Free_Database(&imageDataBase);
  return 0;
}














