#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"
#include "hist-util.h"
#include "filter-util.h"
#include "julesz-util.h"

int main(int argc, char **argv)
{
  char paraFile[256];
  IMAGE_DATABASE imageDataBase;
  int windex, upindex;
  int wsize;
  char prefix[256];
  char fname[256];
  int i,k;
  CONTROL_INFO  para_setting;
  FILTERBANK  fbank;
  IMAGEINT   obs_img, syn_img;
  float  total_err, max_err, weighted_err;
  float total_err_sum;
  int   total_err_times;
  FILE *errfp;

  obs_img.nrow = 0;
  syn_img.nrow = 0;
  if (argc < 1) {
    printf("Please specify the parameter file: ");
    scanf("%s", paraFile);
  }
  else {
    strcpy(paraFile, argv[1]);
  }
  
  LoadParameter(paraFile, &para_setting);
  DisplayParameter(&para_setting);
  
  srand(para_setting.seed);

  fbank.nfilter = 0;

  imageDataBase.nimages =0;
  Read_Filters(para_setting.filterFile, &fbank);
  
  
  if (Load_Database(para_setting.databaseFile, &fbank,
		    &imageDataBase) != 0) {
    Create_Database(&para_setting, &fbank,
		    &imageDataBase);
    Save_Database(para_setting.databaseFile, &fbank,
		  &imageDataBase);
  }
  
  Initialize_Obs(&fbank, &obs_img,
		 &para_setting,
		 &imageDataBase);
  for (k=0; k < fbank.nfilter; k++) {
    printf("Filter %d with %d bins.\n\t", k, fbank.fbank[k].bin_num);
    for (i=0; i< fbank.fbank[k].bin_num; i++) {
      printf("%6.4f ", fbank.fbank[k].target_hist[i]);
    }
    printf("\n");
  }
  printf("Spectral histogram as a long vector\n");
  for (k=0; k < fbank.nfilter; k++) {
    for (i=0; i< fbank.fbank[k].bin_num; i++) {
      printf("%6.4f ", fbank.fbank[k].target_hist[i]);
    }
  }
  printf("\n");
  Free_Image_Int(&obs_img);
  Free_Image_Int(&syn_img);
  Free_Filter_Bank(&fbank);
  Free_Database(&imageDataBase);
  return 0;
}














