#if !defined(TYPE_DEF_H_H)
#define TYPE_DEF_H_H

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#define MAX_LABEL_IMAGE 100
#define MAX_TEXTURE_INPUT 1000

#if !defined(MAXFILENAME)
#define MAXFILENAME 256
#endif

#define NOT_VALID_CROSS_VAL     (-1.0)
#define CROSS_ORIENT_PER_PIXEL  4

#define BACK_LAMBDA            0
#define FRONT_LAMBDA           1
#define INTER_LAMBDA           2

typedef float **MAT;
typedef int   **MAT_I;
typedef float  *ARRAY;
typedef float ***MAT_VECT;
typedef double **DMAT;

typedef struct {
  int ht, wid;
  MAT kernel;
}  MY_KERNEL;

typedef struct {
  int nrow, ncol;
  MAT_I data;
} IMAGEINT;

typedef struct {
  int nrow, ncol;
  MAT data;
} IMAGEFLOAT;

typedef struct {
  int nrow, ncol;
  DMAT data;
} IMAGEDOUBLE;


typedef struct {
  int   len;
  ARRAY fvector;
  ARRAY refineVec;
  
  float threshold;
  float regThres;
  int   label;
  int   segWin, segWsize;
  IMAGEFLOAT resImg;
  float peakVal;
  int   wsize;
  int   bound_x, bound_y;
  int   refWin, refWsize;
  int   seed_row, seed_col;
  float lammda;
  int   histLen;
  float *probHist;
  float histUnit;
  IMAGEFLOAT *crossImg;
} REGION_LABEL;

typedef struct {
  int row, col;
  ARRAY fvector;
  float btw_layerDist;
  float within_layerDist;
  float total_dist;
  float measure;
  float crossDist;
  int  flag;
} HOMO_GROUP;

typedef struct {
  int row, col;
  ARRAY fvector;
  ARRAY lambda_vec;
  char fname[MAXFILENAME];
  char typename[MAXFILENAME];
  char lambdaFile[MAXFILENAME];
  char synImage[MAXFILENAME];
  int  segWin;
  float dist;
} ONE_IMAGE_ENTRY;


typedef struct {
  int nimages;
  ONE_IMAGE_ENTRY *entries;
  char hist_Mark[MAXFILENAME];
  int segWin, topWin;
  int startIndex;
  int num_ref_model;
  int *selected_models;
} IMAGE_DATABASE;


typedef struct {
  int nrow, ncol, len;
  int wsize_x, wsize_y;
  MAT_VECT  data;
} IMAGEVECTOR;


typedef struct {
  int x, y;
} POINT2D;


typedef struct {
  char    name[256];
  int     id;
  int     scale;
  int     wid, ht;          /* TRUE kernel width and height x scale  **/
  ARRAY   kernel;          /* the matrix kernel read as a linear array **/
  int     size;             /* =(2wid+1)/scale  x (2*ht+1)/scale   **/
  int     *rlist, *clist;   /* the coordinate for the sparse filters**/
  int     bin_num;
  float   unit;             /* the length of each bin */
  ARRAY   mark;             /* bin_num-1 marks to split the response
                               into bin_num intervals*/
  ARRAY   hist;
  ARRAY   lambda;
  ARRAY   target_hist;
  float   sum_min, sum_max;
  MAT     patch;
  MAT     patch_hist;
  IMAGEFLOAT   map;
  IMAGEFLOAT   model_lambdas;
  int     flag;
 }   FILTER;

typedef struct {
  int nfilter;
  int usedfilters;
  FILTER *fbank;
  int nlevel;
  POINT2D *winLevels;
  int longestBin;
  int totalBin;
  int clevel;
  int max_wid, max_ht;
  int *filterDim;
  int greyLevel;
  float norm;
} FILTERBANK;


typedef struct {
  int hole_size;
  int row, col; /* This is the upper left corner of the hole */
  int num_ref_model;
  int num_samples;
  int totalBin;
  IMAGEVECTOR hist;
} ONE_HOLE;


typedef struct {
  int nhole;
  int hole_size;
  int num_samples;
  ONE_HOLE *holes; 
  IMAGEINT hole_map;
  IMAGEINT saved_hole_patch;
  IMAGEVECTOR saved_filter_map;
  ARRAY    saved_lambdas;
  IMAGEFLOAT patch_hist;
} DIGGED_HOLES;


typedef struct {
  char  inputFile[MAXFILENAME];
  char  filterFile[MAXFILENAME];
  char  prefix[MAXFILENAME];
  char  histMark[MAXFILENAME];
  char  lambdaFile[MAXFILENAME];
  char  truelambdaFile[MAXFILENAME];
  char  databaseFile[MAXFILENAME];
  char  backlambdaFile[MAXFILENAME];
  char  frontlambdaFile[MAXFILENAME];
  /* Relax factor between a labeled region and the background */
  float lammda;
  int   topWin;
  int   segWin;
  int   npoint;
  float boundWeight;
  POINT2D seedPoints[MAX_LABEL_IMAGE];
  int refinedWin;
  int  interactive;
  int  seed;
  int  seedWin;
  int  seedGrid;
  int  expected_Group;
  float sameLayerWeight;
  float crossDistWeight;
  float groupHomoThreshold;
  int   nInput;
  int   greyLevel;
  char inputFiles[MAX_TEXTURE_INPUT][MAXFILENAME];
  char inputType[MAX_TEXTURE_INPUT][MAXFILENAME];
  char lambdaFiles[MAX_TEXTURE_INPUT][MAXFILENAME];
  char synFiles[MAX_TEXTURE_INPUT][MAXFILENAME];
  float similarityMeasure[MAX_TEXTURE_INPUT];
  int  syn_height, syn_width;
  char initialSyntype[MAXFILENAME];
  int  initialSynval;
  int learningIter;
  float learningAlpha;
  int learningUpdate;
  float learningMaxErrEpsilon;
  int saveSynIter;
  int saveHistogram;
  int  synIter;
  int  synErrIter;
  int  synStartIter;
  float synMaxErrEpsilon;
  float synInitTemp;
  float synLowTemp;
  float synCoolingRatio;
  float synTemp;
  
  /* For julesz ensemble sampling */
  float julesz_synInitTemp;
  float julesz_synLowTemp;
  float julesz_synCoolingRatio;
  float julesz_InitenergyPow;
  float julesz_energyPow;
  int   julesz_regular;
  char  julesz_mark_file[MAX_TEXTURE_INPUT];
  char  julesz_mark_init[MAX_TEXTURE_INPUT];
  int   julesz_mark_init_scale;
  float julesz_powerHeatingRatio;
  int   julesz_seq;
  int   julesz_start_seq;
  float julesz_EndenergyPow;

  /* For satellite learning algorithm */
  float model_too_close;
  int   num_ref_model;
  int   hole_size;
  int   num_of_holes;
  int   overlapped_holes;
  int   include_observed;
  int   chosen_manually;
  int   chosen_ref_models[MAX_TEXTURE_INPUT];
  /* Hole parameter */
  int   hole_syn_init_iter; /* 0 means picking randomly from 
			       the synthesized image */
  int  total_Err_avg_iter;
  int  hole_syn_every_iter;
  int  hole_total_syn;
  /* Additional Hole parameter */
  int holes_regular; /*  if nonzero is the patch size */
  int holes_need_patch_hist; /* Pseudolikelihood needs that */
  int holes_need_hist_vector; /* Satellite algorithms */
  /* Calculate variance */
  int lambdaIter;
  int texture_KL_num_samples;
  int use_analytical_form;
  float shift_hist_percent;
  float accept_chi_threshold;
  int entropy_num;
  float entropy_init_perc, entropy_100_iter_perc;
  float entropy_epsilon;
  float tail_factor, tail_epsilon;
  int   object_center_nrow, object_center_ncol;
  int   object_border_nrow, object_border_ncol;
  int   object_syn_row_start, object_syn_row_end;
  int   object_syn_col_start, object_syn_col_end;
  int   object_org_nrow, object_org_ncol;

} CONTROL_INFO;


#define  Residue(x)  ( (x)>=0 ? (x)%Mat_Size : (x+Mat_Size) )
#define  sq(x)       ((x)*(x))
#define  B(i)        printf(" pass break %d \n", i);

#endif





