void Calculate_MCMC_Mix_Rate_From_A_Hole(CONTROL_INFO *controlInfo, 
					 FILTERBANK *ffamily,
					 IMAGEFLOAT *all_lambdas,
					 DIGGED_HOLES *holefamily,
					 ONE_HOLE *ahole,
					 int cur_hole,
					 IMAGEINT *syn,
					 double *res_vect,
					 float *mix_rate)
{
  int i, j,k, filter_no;
  int k1, k2, iter;
  int crow, ccol;
  float least, sum, r;
  int val;
  FILTER *filter;
  int index;
  int row, col;
  float *energy;
  float *prob;
  ONE_IMAGE_ENTRY *amodel;
  int now_model;
  int now_samples;
  int save_hole_syn_init_iter;
  char fname[256];  
  int iter_lambda;
  int num_samples;
  float *hole_hist;
  double tmp_d;

  row = ahole->row;
  col = ahole->col;
  
  energy = Create_Array(ffamily->greyLevel);
  prob = Create_Array(ffamily->greyLevel);
  hole_hist = Create_Array(ffamily->totalBin);
  
  /* Save the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      holefamily->saved_hole_patch.data[i][j] = 
	syn->data[i+row][j+col];
    }
  }
  /* Save the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	holefamily->saved_filter_map.data[filter_no][k1][k2] = 
	  filter->map.data[i][j];
      }
    }
  }
  /* Save the current lambda's */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
      holefamily->saved_lambdas[ffamily->filterDim[filter_no]+i]
	= filter->lambda[i];
    }
  }

  now_samples = 0;
 
  /* Res_vect: the first is Z(A)
               the second is Z(B)
               the third  is <B_A-B_B, H>
               the fourth is the result 
  */
  
  for (iter_lambda=0; iter_lambda < 4; iter_lambda++) {
    res_vect[iter_lambda] = 0.0;
  }
    
  for (iter_lambda =0; iter_lambda < 2; iter_lambda++) {
    switch(iter_lambda) {
    case 0:
      now_model = INTER_LAMBDA;
      num_samples = ahole->num_samples;
      break;
    case 1:
      now_model = FRONT_LAMBDA;
      num_samples = controlInfo->texture_KL_num_samples;
      break;
    default:
      printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
      printf("This should never happen.\n");
      exit(-1);
    }
    
    now_samples = 0;
    /* We need to synthesize the image with the boundary condition
       when the given synthesized image is not valid. */
    /* Use the current  model lambdas */
    for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
      filter= &(ffamily->fbank[filter_no]);
      for (i=0; i < filter->bin_num; i++) {
	filter->lambda[i] = 
	  all_lambdas->data[now_model][ffamily->filterDim[filter_no]+i];
      }
    }
    
    /* Update the filter responses for an image initialized 
       to be random 
    */
    for (i=0; i < holefamily->hole_size; i++) {
      for (j=0; j < holefamily->hole_size; j++) {
	val = (int)(Unit_Random()*ffamily->greyLevel);
	if (val >= ffamily->greyLevel)
	  val = ffamily->greyLevel - 1;
	Update_Hole_Pixel(ffamily,
			  syn, 
			  (int)(i+row), (int)(j+col), val);
	
      }
    }
    /*
    sprintf(fname, "%s_%d_%d_init.pgm",
	    controlInfo->prefix, cur_hole, now_model);
    Write_An_Image_Int(syn, (int)(256/ffamily->greyLevel), fname);
    */
    switch(now_model) {
    case INTER_LAMBDA:
      printf("For estimating Z(A)/Z(B), generating %d samples ",
	     num_samples);
      printf("from model %d ... \n", now_model);
      break;
    case FRONT_LAMBDA:
      printf("For estimating KL(Pb||Pa), generating %d samples ",
	     num_samples);
      printf("from model %d ... \n", now_model);
      break;
    default:
      printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
      printf("This should never happen.\n");
      exit(-1);
    }
    iter = 0;
    k2 = (controlInfo->hole_syn_init_iter + 
	  controlInfo->hole_syn_every_iter *
	  num_samples)/10;
    do {
      if ( (iter %k2) ==0) {
	printf("%d ", iter);
	fflush(stdout);
      }
      for (k=0; k < (holefamily->hole_size*holefamily->hole_size); k++) {
	do {
	  crow = (int) (Unit_Random()*holefamily->hole_size);
	  ccol = (int) (Unit_Random()*holefamily->hole_size);
	} while ( (crow == holefamily->hole_size) ||
		  (ccol == holefamily->hole_size));
	crow += row;
	ccol += col;
	Update_Patch(ffamily, syn, crow, ccol);
	Calc_Energy(ffamily, crow, ccol, energy);
	least=energy[0];
	for(val=1; val< ffamily->greyLevel; val++) {
	  if ( least>energy[val] ) least=energy[val];
	}
	sum=0;      /* shift and normalize the probability */
	for(val=0; val< ffamily->greyLevel; val++) {
	  sum+=prob[val]=exp(-(energy[val]-least));
	}
	for(val= 0; val< ffamily->greyLevel; val++) {
	  prob[val] /= sum;
	}
	sum=0;
	for(val=0; val< ffamily->greyLevel; val++) {
	  prob[val] += sum;
	  sum=prob[val];
	}
	/** choose the pixel value by the cdf **/
	r = Unit_Random(); val=0;
	while (r > prob[val] ) val++;
	if( val >= ffamily->greyLevel)  val=ffamily->greyLevel-1;
	Update_Map(ffamily, crow, ccol, val);
	syn->data[crow][ccol]=val;
	
	if (holefamily->hole_map.data[crow][ccol] ==0) {
	  printf("Background pixel (%d,%d) is updated mistakenly.\n",
		 ccol, crow);
	}
      }
      if (iter >= controlInfo->hole_syn_init_iter &&
	  ( ( (iter-controlInfo->hole_syn_init_iter) % 
	      controlInfo->hole_syn_every_iter) ==0) ) {
	
	Compute_Hole_Hist_Into_Vector_With_Bound(ffamily,
						 holefamily,
						 ahole,
						 hole_hist);
	switch(now_model) {
	case INTER_LAMBDA:
	  for (i=BACK_LAMBDA; i <= FRONT_LAMBDA; i++) {
	    tmp_d = 0.0;
	    for (j=0; j < ffamily->totalBin; j++) {
	      tmp_d += (double)(hole_hist[j] * 
				(all_lambdas->data[i][j] - 
				 all_lambdas->data[now_model][j]));
	    }
	    tmp_d = 0.0-tmp_d;
	    res_vect[i] += exp(tmp_d);
	  }
	  break;
	case FRONT_LAMBDA:
	  tmp_d = 0.0;
	  for (j=0; j < ffamily->totalBin; j++) {
	    tmp_d += (double)(hole_hist[j] * 
			      (all_lambdas->data[BACK_LAMBDA][j] - 
			       all_lambdas->data[now_model][j]));
	  }
	  res_vect[2] += tmp_d/((double)num_samples);
	  break;
	default:
	  printf("Something must be wrong in Calculate_MCMC_Each_Hole.\n");
	  printf("This should never happen.\n");
	  exit(-1);
	}
	now_samples++;
      }
      if (now_samples >= num_samples) break;
      iter++;
    } while(now_samples < num_samples);  
    printf("%d -- Done.\n", iter);
  }
  res_vect[3] = log((double)(res_vect[0]/res_vect[1])) +
    res_vect[2];
  /* Restore the image */
  for (i=0; i < holefamily->hole_size; i++) {
    for (j=0; j < holefamily->hole_size; j++) {
      syn->data[i+row][j+col] = 
	holefamily->saved_hole_patch.data[i][j];
    }
  }
  
  /* Restore the filter responses */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=row-filter->ht, k1=0; i < row+filter->ht+holefamily->hole_size; 
	 i++, k1++) {
      for (j=col-filter->wid, k2=0; j < col+filter->wid+holefamily->hole_size; 
	   j++, k2++) {
	filter->map.data[i][j] = 
	  holefamily->saved_filter_map.data[filter_no][k1][k2];
      }
    }
  }
  /* Restore the previous lambda's */
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter= &(ffamily->fbank[filter_no]);
    for (i=0; i < filter->bin_num; i++) {
     filter->lambda[i] = 
       holefamily->saved_lambdas[ffamily->filterDim[filter_no]+i];
    }
  }
  free(energy);
  free(prob);
  free(hole_hist);
  return;
}

