#if !defined(UTIL_H_H)
#define UTIL_H_H
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "type-def.h"

#if defined(UTIL_SOURCE_C_C)
#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif

EXTERN_FLAG
float Find_Power_For_Tail_Factor(int bin_num, float tail_factor, 
				 float epsilon);
EXTERN_FLAG int  Round(float x);
EXTERN_FLAG float Unit_Random(void);

EXTERN_FLAG MAT_VECT Create_3D_Matrix(int height,int width, int length);
EXTERN_FLAG void Free_3D_Matrix(MAT_VECT a3Dmat, int height, int width);

EXTERN_FLAG MAT  Create_Matrix(int height,int width);
EXTERN_FLAG void Free_Matrix(MAT anmat, int height);

EXTERN_FLAG MAT_I  Create_Int_Matrix(int height,int width);
EXTERN_FLAG void Free_Int_Matrix(MAT_I anImat, int height);

EXTERN_FLAG ARRAY Create_Array(int length);
EXTERN_FLAG void Free_Array(ARRAY anarrary);

EXTERN_FLAG int Free_Double_Matrix(DMAT aDmat,int size);
EXTERN_FLAG DMAT  Create_Double_Matrix(int height, int width);
EXTERN_FLAG int Copy_Double_Matrix(DMAT from, DMAT to, int size);

EXTERN_FLAG MAT_I Subsample(MAT_I mat0, int row_size, int col_size);

EXTERN_FLAG 
void Normalize_Int_Matrix(MAT_I mat, 
			  int height,int width,int low,int high);
EXTERN_FLAG
int Normalize_Image_Matrix(MAT_I mat, int height, int width,
			   int graylevel, float tailPerc);
EXTERN_FLAG
int Reverse_Normalize_Image_Matrix(MAT_I mat, int height, int width,
				   int graylevel,
				   float min, float max);
EXTERN_FLAG 
int Sweep(DMAT A, int n, int k,  int flag);

EXTERN_FLAG MAT_I Create_Noise_Matrix(int height,int width, 
				      int minVal, int maxVal);
EXTERN_FLAG MAT_I Create_Const_Matrix(int height,int width, int cVal);
#undef  EXTERN_FLAG
#endif

