#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"
#include "hist-util.h"
#include "filter-util.h"
#include "hole-util.h"

int main(int argc, char **argv)
{
  char paraFile[256];
  IMAGE_DATABASE imageDataBase;
  int windex, upindex;
  int wsize;
  char prefix[256];
  char fname[256];
  int i,j,k;
  CONTROL_INFO  para_setting;
  FILTERBANK  fbank;
  IMAGEINT   obs_img, syn_img;
  float  total_err, max_err, weighted_err;
  FILE *errfp;
  DIGGED_HOLES holes_digged;
  IMAGEFLOAT   all_lambdas;
  double  total_var;
  all_lambdas.nrow = 0;
  holes_digged.nhole = 0;
  obs_img.nrow = 0;
  syn_img.nrow = 0;
  if (argc < 1) {
    printf("Please specify the parameter file: ");
    scanf("%s", paraFile);
  }
  else {
    strcpy(paraFile, argv[1]);
  }
  
  LoadParameter(paraFile, &para_setting);
  DisplayParameter(&para_setting);
  
  srand(para_setting.seed);

  fbank.nfilter = 0;

  imageDataBase.nimages =0;
  imageDataBase.num_ref_model =0;
  Read_Filters(para_setting.filterFile, &fbank);
  
  
  if (Load_Database(para_setting.databaseFile, &fbank,
		    &imageDataBase) != 0) {
    Create_Database(&para_setting, &fbank,
		    &imageDataBase);
    Save_Database(para_setting.databaseFile, &fbank,
		  &imageDataBase);
  }
  
  fbank.greyLevel = para_setting.greyLevel;
  Initialize_Obs(&fbank, &obs_img,
		 &para_setting,
		 &imageDataBase);
  
  Initialize_Syn(&fbank, &syn_img, &para_setting);
  
  
  Scale_Target_Hist(&fbank, (float)(fbank.norm));
  
  
  Create_An_Image_Float((int)(para_setting.lambdaIter+2),
			fbank.totalBin, 
			&all_lambdas);
  /* Force not to save Histogram data */
  para_setting.saveHistogram = 0;
  strcat(para_setting.prefix,"_var_frame");
  for (k=0; k < para_setting.lambdaIter; k++) {
    for (i=0; i < fbank.nfilter; i++) {
      for (j=0; j < fbank.fbank[i].bin_num; j++) {
	fbank.fbank[i].lambda[j] = 0.0;
      }
    }

    Re_Initialize_Syn(&fbank, &syn_img, &para_setting);
    
    for (i=0; i < para_setting.learningIter; i++) {
      if ( (i%para_setting.learningUpdate) ==0) {
	Update_Syn_Filters(&fbank, &syn_img);
	Generate_Hist_From_Map(&fbank);
	printf("Updating lambdas ... \n");
	sprintf(fname,"%s_learn_Histogram.dat", para_setting.prefix);
	total_err = Update_Lambda(i,fname, 
				  &fbank,
				  &para_setting,
				  &max_err,
				  &weighted_err);
	
	if (max_err < para_setting.learningMaxErrEpsilon) break;
      }
      Flip(&syn_img, &fbank, &para_setting);
    }
    
    Save_Lambdas_Into_Vector(&fbank,
			     (all_lambdas.data[k]));
    sprintf(fname,"%s_lambdas_all.dat", para_setting.prefix);
    if (k==0) {
      Save_Lambda_To_File(&fbank, fname);
    }
    else {
      Save_Lambda_To_File_Append(&fbank, fname);
    }
  }
  
  for (i=0; i < all_lambdas.ncol; i++) {
    all_lambdas.data[para_setting.lambdaIter][i] = 0.0;
    all_lambdas.data[para_setting.lambdaIter+1][i] = 0.0;
  }
  for (k=0; k < para_setting.lambdaIter; k++) {
    for (i=0; i < all_lambdas.ncol; i++) {
      all_lambdas.data[para_setting.lambdaIter][i] += 
	all_lambdas.data[k][i];
    }
  }
  total_err = 0.0;
  for (i=0; i < all_lambdas.ncol; i++) {
    all_lambdas.data[para_setting.lambdaIter][i] 
      /= (float)para_setting.lambdaIter;
    total_err += fabsf(all_lambdas.data[para_setting.lambdaIter][i]);
  }
  total_err /= (float)all_lambdas.ncol;
  total_var = 0.0;
 
  for (k=0; k < para_setting.lambdaIter; k++) {
    for (i=0; i < all_lambdas.ncol; i++) {
      all_lambdas.data[para_setting.lambdaIter+1][i] +=
	(all_lambdas.data[k][i]-all_lambdas.data[para_setting.lambdaIter][i]) *
	(all_lambdas.data[k][i]-all_lambdas.data[para_setting.lambdaIter][i]);
      total_var += all_lambdas.data[para_setting.lambdaIter+1][i];
    }
  }
  sprintf(fname,"%s_lambdas_all.dat", para_setting.prefix);
  Save_Lambda_To_File_Append_From_Vector(&fbank, fname,
			  all_lambdas.data[para_setting.lambdaIter]);
  Save_Lambda_To_File_Append_From_Vector(&fbank, fname,
			  all_lambdas.data[para_setting.lambdaIter+1]);
  total_var /=  (float)(para_setting.lambdaIter*all_lambdas.ncol);
  
  printf("Variance of estimated lambdas is %12.10lf\n", total_var);
  printf("Normalized variance of estimated lambdas is %12.10lf\n",
	 (double)(total_var/total_err));
  errfp = fopen(fname,"ab");
  fprintf(errfp,"Total iteration: %d vector length %d\n",
	  para_setting.lambdaIter, all_lambdas.ncol);
  
  fprintf(errfp,"Variance of estimated lambdas is %12.10lf\n", total_var);
  fprintf(errfp,"Normalized variance of estimated lambdas is %12.10lf\n",
	  (double)(total_var/total_err));
  fclose(errfp);
  Free_Holes(&holes_digged);
  Free_Image_Int(&obs_img);
  Free_Image_Int(&syn_img);
  Free_Image_Float(&all_lambdas);
  Free_Filter_Bank(&fbank);
  Free_Database(&imageDataBase);
  return 0;
}














