#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"
#include "hist-util.h"
#include "filter-util.h"
#include "hole-util.h"

int main(int argc, char **argv)
{
  char paraFile[256];
  IMAGE_DATABASE imageDataBase;
  int windex, upindex;
  int wsize;
  char prefix[256];
  char fname[256];
  int i,j,k;
  CONTROL_INFO  para_setting;
  FILTERBANK  fbank;
  IMAGEINT   obs_img, syn_img;
  float  total_err, max_err, weighted_err;
  FILE *errfp;
  DIGGED_HOLES holes_digged;
  IMAGEFLOAT   all_lambdas;
  IMAGEDOUBLE  KL_img;
  double  total_var;
  all_lambdas.nrow = 0;
  holes_digged.nhole = 0;
  KL_img.nrow = 0;
  obs_img.nrow = 0;
  syn_img.nrow = 0;
  if (argc < 1) {
    printf("Please specify the parameter file: ");
    scanf("%s", paraFile);
  }
  else {
    strcpy(paraFile, argv[1]);
  }
  
  LoadParameter(paraFile, &para_setting);
  DisplayParameter(&para_setting);
  
  srand(para_setting.seed);

  fbank.nfilter = 0;

  imageDataBase.nimages =0;
  imageDataBase.num_ref_model =0;
  Read_Filters(para_setting.filterFile, &fbank);
  
  
  if (Load_Database(para_setting.databaseFile, &fbank,
		    &imageDataBase) != 0) {
    Create_Database(&para_setting, &fbank,
		    &imageDataBase);
    Save_Database(para_setting.databaseFile, &fbank,
		  &imageDataBase);
  }
  
  fbank.greyLevel = para_setting.greyLevel;
  Initialize_Obs_Satellite(&fbank, &obs_img,
			   &para_setting,
			   &imageDataBase);
  
  Initialize_Syn_Satellite(&fbank, &syn_img, &para_setting);
  
  Create_Holes(&para_setting,
	       &fbank,
	       &imageDataBase,
	       &obs_img,
	       &holes_digged,
	       (int)0);
  Generate_Target_Hist_From_Image_WithHoles(&fbank, &obs_img,
					    &(holes_digged.hole_map));
  /*Generate_All_Holes(&para_setting,
		     &fbank,
		     &imageDataBase,
		     &holes_digged,
		     &syn_img);
  */
  Scale_Target_Hist(&fbank, (float)(fbank.norm));
  
  /*
    sprintf(fname,"%s_obs.pgm", para_setting.prefix);
    Write_An_Image_Int(&obs_img, (int)(256/para_setting.greyLevel),
    fname);
    
    sprintf(fname,"%s_syn_init.pgm", para_setting.prefix);
    Write_An_Image_Int(&syn_img, (int)(256/para_setting.greyLevel),
    fname);
  */
  strcat(para_setting.prefix,"_with_bound");
  Create_An_Image_Float((int)(3),
			fbank.totalBin, 
			&all_lambdas);
  k = 0;
  if (para_setting.backlambdaFile[0] != '\0') {
    if (Read_Lambdas_Into_Vector(para_setting.backlambdaFile,
                                 &fbank,
                                 all_lambdas.data[BACK_LAMBDA]) 
	== fbank.totalBin) {
      k = 1;
    }
  }
  if (k != 1) {
    printf("Cannot load the background texture model from file '%s'.\n",
	   para_setting.backlambdaFile);
    Free_Holes(&holes_digged);
    Free_Image_Int(&obs_img);
    Free_Image_Int(&syn_img);
    Free_Image_Float(&all_lambdas);
    Free_Filter_Bank(&fbank);
    Free_Database(&imageDataBase);
    return (-1);
  }
  
  k = 0;
  if (para_setting.frontlambdaFile[0] != '\0') {
    if (Read_Lambdas_Into_Vector(para_setting.frontlambdaFile,
                                 &fbank,
                                 all_lambdas.data[FRONT_LAMBDA]) 
	== fbank.totalBin) {
      k = 1;
    }
  }
  
  if (k != 1) {
    printf("Cannot load the front texture model from file '%s'.\n",
	   para_setting.frontlambdaFile);
    Free_Holes(&holes_digged);
    Free_Image_Int(&obs_img);
    Free_Image_Int(&syn_img);
    Free_Image_Float(&all_lambdas);
    Free_Filter_Bank(&fbank);
    Free_Database(&imageDataBase);
    return (-1);
  }
  
  for(k=0; k < fbank.totalBin; k++) {
    all_lambdas.data[INTER_LAMBDA][k] = 
      (all_lambdas.data[BACK_LAMBDA][k] + 
       all_lambdas.data[FRONT_LAMBDA][k])/2.;
  }
  
  /* Force not to save Histogram data */
  para_setting.saveHistogram = 0;
  Create_An_Image_Double(holes_digged.nhole,
			 (int)4, &KL_img);
  Calculate_MCMC_All_Holes(&para_setting,
			   &fbank,
			   &all_lambdas,
			   &holes_digged,
			   &syn_img,
			   &KL_img);
  sprintf(fname,"%s_texture_KL_holes.dat", para_setting.prefix);
  errfp = fopen(fname,"wb");
  total_var = 0.0;
  for (k=0; k < KL_img.nrow; k++) {
    fprintf(errfp,"%4dth hole ->", k+1);
    for (i=0; i < 4; i++) {
      fprintf(errfp," %12.10lf", KL_img.data[k][i]);
    }
    fprintf(errfp,"\n");
    total_var +=  KL_img.data[k][3];
  }
  
  fprintf(errfp,"For %d holes with size %d, total KL is  %12.10lf\n",
	  KL_img.nrow, holes_digged.hole_size,
	  total_var);
  fprintf(errfp,"\tAverage KL distance per hole %12.10lf per pixel %12.10lf\n",
	  (double)(total_var/(double)KL_img.nrow),
	  (double)(total_var/((double)(KL_img.nrow*
				       holes_digged.hole_size*
				       holes_digged.hole_size))));
  fclose(errfp);
  
  printf("For %d holes with size %d, total KL is  %12.10lf\n",
	  KL_img.nrow, holes_digged.hole_size,
	  total_var);
  printf("\tAverage KL distance per hole %12.10lf per pixel %12.10lf\n",
	 (double)(total_var/(double)KL_img.nrow),
	 (double)(total_var/((double)(KL_img.nrow*
				      holes_digged.hole_size*
				      holes_digged.hole_size))));
  Free_Holes(&holes_digged);
  Free_Image_Int(&obs_img);
  Free_Image_Int(&syn_img);
  Free_Image_Float(&all_lambdas);
  Free_Image_Double(&KL_img);
  Free_Filter_Bank(&fbank);
  Free_Database(&imageDataBase);
  return 0;
}














