%
% Subsampling
%
load trainID;
load testID;
nc=500;      % number of codes
ns=200;      % number of samples for each images
np=1;
image_sift='.\sift';
D=dir(image_sift);

%%
sift_x=[];
sift_y=[];
sift_pos=[];
for i=3:length(D)
    sift_fold=[image_sift '\' D(i).name];
    img_sift=dir(sift_fold);
    for j=1:trainsize
        load ([sift_fold '\' img_sift(trainID(i-2,j)+2).name]);
        inds=randperm(size(x,1));
        sift_x=[sift_x; x(inds(1:ns), :)];
    end;
end;
%
% K-means clustering algorithm
%
cluster_labels = k_means(sift_x,[],nc);
%
% decoding
%
%% buidling K-d tree
code_add=['.\train_code'];
% create a file fold
mkdir(code_add);
anno = ann(sift_x');
for i=3:length(D)
    sift_fold=[image_sift '\' D(i).name];
    % create a code fold
    code_fold=[code_add '\' D(i).name];
    mkdir(code_fold);
    img_sift=dir(sift_fold);
    for j=1:trainsize
        load ([sift_fold '\' img_sift(trainID(i-2,j)+2).name]);
        % to decode the sift features
        [idx dst] = ksearch(anno, x', np,1.0);
        code=cluster_labels(idx');
        disp(['encoding code_' num2str(j)]);
        save ([code_fold '\' 'code_' num2str(j)], 'code');
    end;
end;

code_add=['.\test_code'];
% create a file fold
mkdir(code_add);
anno = ann(sift_x');
for i=3:length(D)
    sift_fold=[image_sift '\' D(i).name];
    % create a code fold
    code_fold=[code_add '\' D(i).name];
    mkdir(code_fold);
    img_sift=dir(sift_fold);
    for j=1:testsize
        load ([sift_fold '\' img_sift(testID(i-2,j)+2).name]);
        % to decode the sift features
        [idx dst] = ksearch(anno, x', np,1.0);
        code=cluster_labels(idx');
        disp(['encoding code_' num2str(j)]);
        save ([code_fold '\' 'code_' num2str(j)], 'code');
    end;
end;
close (anno);