%% generates html documentation to show experimental results.
clear all;
close all;

%% parameter setting for generating html
load ('paraImg.mat');          % image filefold, image format, training and testing ids
load ('partLocConfig.mat');    % templateSize category locationShiftLimit...
load learning_result;
load L0_acc;
zipname = sprintf('EMScanSupression_%s.zip',date);
imFolder = 'EMScanSupression';
html_dir = 'document';
maxDisplayImg = 300;           % maximum number of images per category

%% remove the previous version
html_dir = 'document';        
if ~exist(html_dir,'dir')
    mkdir(html_dir);
end
html_img_dir = sprintf('document/%s/',imFolder);
if ~exist(html_img_dir,'dir')
    mkdir(html_img_dir);
end
html_path = sprintf('%s/%s.html',html_dir,imFolder);
html = fopen(html_path,'wt');

%% html header
% note: modified on Jan 13, 2010. Some url's are now absolute. Only 
%   copied files are linked with relative url.
tmp = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">\n';
tmp = [tmp '<html>\n'];
tmp = [tmp '<head>\n'];
tmp = [tmp '<title>Learning Codebooks of Deformable Templates for Sparse Image Representation</title>\n'];
tmp = [tmp '</head>\n'];
fprintf(html,tmp);
fprintf(html, '<body>\n');
fprintf( html, '<div id="header">\n');
fprintf( html, '<h1>Learning Codebooks of Deformable Templates for Sparse Image Representation</h1></div>\n' );
fprintf( html, '\n<div id="content">\n');

%% table of content
fprintf( html, '<div id="content">\n' );
fprintf( html, '<div id="TableOfContents">\n' );
fprintf( html, '<p>Contents</p>\n' );
fprintf( html, '<ul>\n' );
fprintf( html, '<li>\n' );
fprintf( html, '<A href="#download">Download</A>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '<li>\n' );
fprintf( html, '<A href="#parameter">Parameter settings</A>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '<li>\n' );
fprintf( html, '<A href="#accuracy">Classification accuracy</A>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '<li>\n' );
fprintf( html, '<A href="#templates">Learned templates</A>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '<li>\n');
fprintf( html, '<a href="#traindata">Training images and their sketch</a>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '<li>\n' );
fprintf( html, '<a href="#testdata">Testing images and their sketch</a>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '</ul>\n' );
fprintf( html, '</div>\n' );

%% for download
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div><h2> ');
fprintf(html, '<a name="download"></a> (I) Download');
fprintf(html, ' </h2>');
fprintf( html, '<div style="border-bottom:1 solid #dddddd; margin-top:0.3em;"></div>\n' );
fprintf( html, '<a name="download"></a> <table cellspacing="10" cellpadding="10" class="center" width="60%%">\n' );
fprintf( html, '\n<tr><td>\n' );
fprintf( html, '\n<b>Code and data: (<a href="%s">ZIP</a>).</b>\n', zipname );
fprintf( html, '\n</td>\n' );
fprintf( html, '\n<td>\n' );
fprintf( html, '\n</td>\n' );
fprintf( html, '\n</tr>\n' );
fprintf( html, '\n<tr>\n' );
fprintf( html, '\n<td colspan=2 align=left>\n' );
fprintf( html, '\nRun StartFromHere.m in Matlab. You can monitor intermediate results in the folder: output/. \n' );
fprintf( html, '\n</td>\n' );
fprintf( html, '\n</tr>\n' );
fprintf( html, '\n</table>\n' );

%% explain the parameters
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div><h2> ');
fprintf(html, '<a name="parameter"></a> (II) Parameter settings');
fprintf(html, ' </h2>');
fprintf( html, sprintf('The size of each active basis template is %d (width) by %d (height) pixels. ',templateSize(2),templateSize(1)));
fprintf( html, sprintf('Maximum number of Gabor elements in each template is %d. ',numElement));
fprintf( html, sprintf('For Gabor wavelets we use a scale of %.2f and %d quantized orientations within PI (in radian). ',scales,numOrient));
fprintf( html, sprintf('Each Gabor element is allowed to move %d pixels and rotate %d orientation step(s) at most. ',locationShiftLimit,orientShiftLimit));
fprintf( html, sprintf('We perform soft thresholding at %.2f on SUM1 scores (Gabor responses) to reduce background clutter. </p\n> ',S1softthres) );
fprintf( html, sprintf('<p>In total we learn %d active basis templates (i.e. clusters). ',numCluster));
fprintf( html, sprintf('For EM learning, we randomly start at %d initializations. ',numRandomStart));
fprintf( html, sprintf('Then %d EM iterations are carried out. ',numIter));
fprintf( html, sprintf('In the M step, for each cluster we use a maximum of %d examples to re-learn the active basis model. ',maxNumClusterMember));
fprintf( html, sprintf('In the E step, the activated templates need to have a SUM2 score of at least %d. ',S2Thres));
fprintf( html, sprintf('For local inhibition between templates, the minimum distance between two activated template is %.2f times the size of template. ',locationPerturbationFraction));
fprintf( html, sprintf('In later EM iterations, this is increased to %.2f resulting in sparser representation. ',locationPerturbationFraction_final));
fprintf( html, sprintf('Allowed template rotations: ['));
fprintf( html, sprintf('%d',rotationRange(1)) );
for rr = rotationRange(2:end)
	fprintf( html, sprintf(', %d',rr) );
end
fprintf( html, ']. ');
fprintf( html, sprintf('Allowed image resolutions (relative): ['));
fprintf( html, sprintf('%.2f',allResolution(1)) );
for rr = allResolution(2:end)
	fprintf( html, sprintf(', %.2f',rr) );
end
fprintf( html, ']. ');
if resizeTrainingImages
	fprintf( html, sprintf('As a pre-processing step, the input images are resized so that the number of pixels is roughly %d pixels. ',constantArea^2));
end
fprintf( html, '</p>\n ');

%% show classification accuracy
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div><h2> ');
fprintf(html, '<a name="accuracy"></a> (III) Classification accuracy');
fprintf(html, ' </h2>');
fprintf( html, '\n<p>The classification accuracy is %2.2f, if %d object images (positive), %d background images (negative) are used for training; and  %d object images (positive), %d background images (negative) are used for testing. </p>\n',L0_acc,trainsize,trainsize,testsize, testsize);

%% show learned templates
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div><h2> ');
fprintf(html, '<a name="templates"></a> (IV) Templates (visual codes)');
fprintf(html, ' </h2>');
fprintf( html, ['<div style="border-bottom:1 solid #dddddd; margin-top:0.3em;"></div>\n<a name="templates"></a><p>Learned templates (some clusters may be empty): </p>\n']);
fprintf( html, '\n<p>' );
nonemptyCluster=length(dir(['./output/template_sorted' '*.png']));
for ii=1:nonemptyCluster
    new_img_name = sprintf('template_sorted%d.png',ii);
    src = sprintf('./output/%s',new_img_name);
    dst = sprintf('document/%s/%s', imFolder,new_img_name);
    copyfile(src,dst);
    fprintf( html, '\n<img src="%s" alt="" width="50"/>', sprintf('%s/%s',imFolder,new_img_name) );
end;
fprintf( html, '\n</p>\n' );
fprintf( html, ['<div style="border-bottom:1 solid #dddddd; margin-top:0.3em;"></div>\n<a name="templates"></a><p>Templates at different iterations: </p>\n']);
fprintf( html, '\n<p>' );
for iter=1:numIter
    fprintf( html, sprintf('Iteration%2d',iter));
    for ii=1:numCluster
        new_img_name = sprintf('template%d%d.png',iter,ii);
        src = sprintf('./output/%s',new_img_name);
        dst = sprintf('document/%s/%s', imFolder,new_img_name);
        copyfile(src,dst);
        fprintf( html, '\n<img src="%s" alt="" width="50"/>', sprintf('%s/%s',imFolder,new_img_name) );
    end;
    fprintf( html, '<br>');
end;
fprintf( html, '\n</p>\n' );

%% show training images and their sketches
tr_or_ts='train_';  % train or test?
working_add='train_working';  
load train_activations;
activations =train_activations;
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div><h2> ');
fprintf(html, '<a name="traindata"></a>(V) Training images and their sketch');
fprintf(html, ' </h2>');
fprintf( html, ['\n<p>Show learned templates with different colors: </p>\n']);
subfold_name = dir(trainI_fold);
Iname=[];
selected_img=[];
sub_fold=[trainI_fold '/' 'positiveImage'];
sub_img=dir([sub_fold '/' img_format]); 
n=length(sub_img);
for j=1:length(sub_img);
    sub_img(j).name=['positiveImage' '/' 'trainI_' num2str(j) img_format(2:end)];
end;
if n>maxDisplayImg
    ind = randperm(n);
    sub_selected_img=ind(1:maxDisplayImg);
    Iname=[Iname; sub_img(sub_selected_img)];
    selected_img=[selected_img sub_selected_img];
else
    selected_img = [selected_img (1:n)];
    Iname=[Iname; sub_img];
end;
% render sketched images with activated partial templates
destFolder = sprintf('document/%s',imFolder);
displayActivations;
% move the images to img/ folder
for i = 1:length(Iname)
    new_img_name = Iname(i).name;
    src = sprintf('trainImage/%s',new_img_name);
    idx=strfind(new_img_name,'/');
    new_img_name(idx)='_';
    dst = sprintf('document/%s/%s%s',imFolder, tr_or_ts,new_img_name);
    copyfile(src,dst);
end
% generate corresponding html
for ii=1:numCluster
    new_tmp_name = sprintf('colortemplate%d.png',ii);
    src = sprintf('./output/%s',new_tmp_name);
    dst = sprintf('document/%s/%s', imFolder,new_tmp_name);
    copyfile(src,dst);
    fprintf( html, '\n<img src="%s" alt="" width="60"/>', sprintf('%s/%s',imFolder,new_tmp_name) );
end;
fprintf( html, ['\n<p>Show some training images and their sketchs: </p>\n']);
activatedCluster = ceil( ( activations(5,:) + 1 ) / nTransform );
fprintf( html, '\n<p>' );
for i = 1:trainsize
    idx=strfind(Iname(i).name,'/');
    Iname(i).name(idx)='_';
    fprintf( html, '<img src="%s" alt="" height=60/>', sprintf('%s/%s%s',imFolder,tr_or_ts,Iname(i).name ));
    fprintf( html, '<img src="%s" alt="" height=60/>',  sprintf('%s/%soverlayed_image%d.png',imFolder,tr_or_ts,selected_img(i)));
    fprintf( html, '<img src="%s" alt="" height=60/>',  sprintf('%s/%scolorsketch_image%d.png',imFolder,tr_or_ts,selected_img(i)));
    fprintf( html, '<img src="%s" alt="" height=60/>',  sprintf('%s/%ssketch_image%d.png',imFolder,tr_or_ts,selected_img(i)));
    fprintf( html, '<br>');
end
fprintf( html, '\n</p>\n' );


%% testing examples
working_add='test_working';
tr_or_ts='test_';
load test_activations;
activations =test_activations;
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div><h2> ');
fprintf(html, '<a name="testdata"></a>(VI) Testing images and their sketch');
fprintf(html, ' </h2>');
fprintf( html, ['\n<p>Show some testing images and their sketchs: </p>\n']);% generate corresponding html
fprintf( html, '\n<p>' );
subfold_name = dir(testI_fold);
Iname=[];
selected_img=[];
for i=4:length(subfold_name)
    sub_fold=[testI_fold '/' subfold_name(i).name];
    sub_img=dir([sub_fold '/' img_format]); 
    n=length(sub_img);
    for j=1:length(sub_img);
        sub_img(j).name=[subfold_name(i).name '/' 'testI_' num2str(j) img_format(2:end)];
    end;
    if n>maxDisplayImg
        ind = randperm(n);
        sub_selected_img=ind(1:maxDisplayImg);
        Iname=[Iname; sub_img(sub_selected_img)];
        selected_img=[selected_img sub_selected_img];
    else
        selected_img = [selected_img (1:n)];
        Iname=[Iname; sub_img];
    end;
end;
% render sketched images with activated partial templates
destFolder = sprintf('document/%s',imFolder);
displayActivations;
% move the images to img/ folder
for i = 1:length(Iname)
    new_img_name = Iname(i).name;
    src = sprintf('testImage/%s',new_img_name);
    idx=strfind(new_img_name,'/');
    new_img_name(idx)='_';
    dst = sprintf('document/%s/%s%s',imFolder, tr_or_ts, new_img_name);
    copyfile(src,dst);
end
activatedCluster = ceil( ( activations(5,:) + 1 ) / nTransform );
fprintf( html, '\n<p>' );
for i = 1:testsize
    idx=strfind(Iname(i).name,'/');
    Iname(i).name(idx)='_';
    fprintf( html, '<img src="%s" alt="" height=60/>', sprintf('%s/%s%s',imFolder,tr_or_ts,Iname(i).name ));
    fprintf( html, '<img src="%s" alt="" height=60/>',  sprintf('%s/%soverlayed_image%d.png',imFolder,tr_or_ts,selected_img(i)));
    fprintf( html, '<img src="%s" alt="" height=60/>',  sprintf('%s/%scolorsketch_image%d.png',imFolder,tr_or_ts,selected_img(i)));
    fprintf( html, '<img src="%s" alt="" height=60/>',  sprintf('%s/%ssketch_image%d.png',imFolder,tr_or_ts,selected_img(i)));
    fprintf( html, '<br>');
end
fprintf( html, '\n</p>\n' );

%% finishing off
fprintf( html, '\n\n\n</div> \n');
fprintf( html, '<div id="last" class="footer"></div>' );
fprintf(html, '</body> </html> \n');
fclose(html);
disp('finished generating Html.. check here:');
disp([pwd '/' html_path]);
close all
