%% randomly divide images are training and testing without replacement
trainI_fold='./trainImage';        % training images filefold
mkdir(trainI_fold);
testI_fold='./testImage';          % testing image filefold
mkdir(testI_fold);
Con=dir(img_fold);
trainID=[];
testID=[];
for i=3:length(Con)                % divide images as train and test
    sub_trainI_fold=[trainI_fold '/' Con(i).name];
    mkdir(sub_trainI_fold);
    sub_testI_fold=[testI_fold '/' Con(i).name];
    mkdir(sub_testI_fold);
    sub_img_fold=[img_fold '/' Con(i).name];
    img=dir([sub_img_fold '/' img_format]);
    id=randperm(length(img));
    for j=1:trainsize
        src=[sub_img_fold '/' img(id(j)).name]; 
        dst=[sub_trainI_fold '/' 'trainI_' num2str(j) img_format(2:end)];
        copyfile(src,dst);
    end;
    trainID=[trainID; id(1:trainsize)];
    for j=1:testsize
        src=[sub_img_fold '/' img(id(trainsize+j)).name]; 
        dst=[sub_testI_fold '/' 'testI_' num2str(j) img_format(2:end)];
        copyfile(src,dst);
    end;
    testID=[testID; id(1+trainsize:testsize+trainsize)];
end;

save trainID trainID;
save testID testID;