%% Testing process
clear all;
close all;
%% parameter settings
load ('paraImg.mat');
load ('partLocConfig.mat');
%% parameter settings for testing
all_I_fold='./testImage';         % image fold
all_I_n=dir(all_I_fold); 
all_W_fold='./test_working';      % working fold
mkdir(all_W_fold);                
numExtendTest = 1; % this value can be different from training process
numResolutionTest = numExtendTest*2 + 1;  % number of resolutions to search for in detection stage
originalResolutionTest = numExtendTest + 1; % original resolution is the one at which the imresize factor = 1
allResolutionTest = (-numExtendTest : numExtendTest)*resolutionGap + 1.;
save('PamaTest', 'numExtendTest', 'numResolutionTest', 'originalResolutionTest','allResolutionTest', 'all_I_fold', 'all_W_fold', 'all_S_fold','all_I_n');
load ('PamaTest.mat');
%% read images
for all_I_c=3:length(all_I_n)
    %%
    mkdir(['test_working/' all_I_n(all_I_c).name]);        % working directory to store .mat files. 
    imageFolder = [all_I_fold '/' all_I_n(all_I_c).name];  % folder of training images  
    imageName = dir([imageFolder '/' img_format]);
    numImage = length(imageName);
    Ioriginal = cell(1, numImage);
    for img = 1 : numImage
        tmpIm = imread([imageFolder '/' 'testI_' num2str(img) img_format(2:end)]); 
        if size(tmpIm,3) == 3
            tmpIm = rgb2gray(tmpIm);
        end
        sx = size(tmpIm,1); sy = size(tmpIm,2);
        if resizeTrainingImages
            tmpIm = imresize( tmpIm, constantArea/sqrt(sx*sy), 'bilinear' );
        end
        Ioriginal{img} = single(tmpIm);
        J0 = Ioriginal{img};
        J = cell(1, numResolutionTest);
        for r=1:numResolutionTest
           J{r} = imresize(J0, allResolutionTest(r), 'nearest');  % scaled images
        end
        multipleResolutionImageName = ['test_working/' all_I_n(all_I_c).name '/' 'multipleResolutionImage' num2str(img)]; 
        save(multipleResolutionImageName, 'J');
    end
    clear Ioriginal;
end;

numResolution=numResolutionTest;
numExtend=numExtendTest;
allResolution=allResolutionTest;
originalResolution=originalResolutionTest;

%% load learned model
load ('learning_result.mat');     
S2Templates = cell(numCluster,1);
for cc = 1:numCluster
    S2Templates{cc} = bestS2Templates{cc};
end
TransformedTemplate = cell(nTransform,numCluster);
selectedScale = zeros(1,length(S2Templates{1}.selectedx),'single');
for cc = 1:numCluster
    for iT = 1:nTransform
        templateScaleInd = templateTransform{iT}(1);
        rowScale = templateTransform{iT}(2);
        colScale = templateTransform{iT}(3);
        rotation = templateTransform{iT}(4);
        [tmpSelectedRow tmpSelectedCol tmpSelectedOri tmpSelectedScale] = ...
            mexc_TemplateAffineTransform( templateScaleInd, rowScale,...
            colScale, rotation, S2Templates{cc}.selectedRow, S2Templates{cc}.selectedCol,...
            S2Templates{cc}.selectedOri, selectedScale, numOrient );
        TransformedTemplate{iT,cc}.selectedRow = tmpSelectedRow;
        TransformedTemplate{iT,cc}.selectedCol = tmpSelectedCol;
        TransformedTemplate{iT,cc}.selectedOri = tmpSelectedOri;
        TransformedTemplate{iT,cc}.selectedScale = tmpSelectedScale;
        TransformedTemplate{iT,cc}.selectedLambda = S2Templates{cc}.selectedLambda;
        TransformedTemplate{iT,cc}.selectedLogZ = S2Templates{cc}.selectedLogZ;
    end
end

%% prepare for affinity matrix
templateAffinityMatrix = cell( numCluster * nTransform, 1 );
for cc = 1:numCluster
    from = 1; to = nTransform*numCluster;
    for jj = 1:nTransform
        templateAffinityMatrix{jj+(cc-1)*nTransform} = int32((from:to)-1);
    end
end

%% Preparation
for all_I_c=3:length(all_I_n)
    test_SUM1MAX1;
end;

%% decoding process
all_W_n=dir(all_W_fold);
 for all_W_c=3:length(all_W_n)
    sub_sum1max1_file=[all_W_fold '/' all_W_n(all_W_c).name];
    file_name=dir([sub_sum1max1_file  '/SUM1MAX1map'  '*.mat']);
    positive_activations = []; % 3 by N matrix, where N is an unknown large number
    L0_positive_data=[];
    test_activations = [];
    for file_i=1:length(file_name)
        SUM1MAX1mapName = [sub_sum1max1_file '/SUM1MAX1map' 'image' num2str(file_i) 'scale' num2str(1)];
        disp(['decoding image' num2str(file_i)]);
        load(SUM1MAX1mapName, 'SUM1map', 'MAX1map', 'M1RowShift', 'M1ColShift',...
                'M1OriShifted', 'J');
        for iRes = 1:numResolution
            SUM2map(:,iRes) = mexc_ComputeSUM2( numOrient, MAX1map(iRes,:), TransformedTemplate, subsampleS2 );
        end
        tmpActivations = mexc_ComputeMAX2MP( SUM2map, int32(locationPerturbationFraction*partSize/subsampleS2), S2Thres );
        test_activations = [test_activations,[single(file_i*ones(1,size(tmpActivations,2)));tmpActivations]];
        % random perturbation (to break ties arbitrarily for MAX2)
        L0_positive_sum=[];
        for ii = 1:numel(SUM2map(:,iRes))
            tmp_max=[];
            for iRes=1:numResolution
                SUM2map{ii,iRes}(:) = SUM2map{ii,iRes}(:) + 1e-3 * ( rand(numel(SUM2map{ii,iRes}),1) - .5 );
                CC=double(SUM2map{ii,iRes}(:,:));
                t1=max(max( CC ));
                tmp_max=[tmp_max; t1];
            end;
            if numResolution>1
                tmp_max=max(tmp_max);
            end;
            L0_positive_sum =[L0_positive_sum tmp_max(1)];
        end
        L0_positive_data=[L0_positive_data; L0_positive_sum];
    end;
    test_activations(2:3,:) =test_activations(2:3,:) * subsampleS2;
    save ([all_S_fold '/' 'test' all_W_n(all_W_c).name 'Score'],'L0_positive_data');
end; 
save test_activations test_activations;
