% 
% read image from image dataset
%
close all;
clear all;

%% parameter settings
disp('start reading image....');
img_file='.\image';
load trainID;
load testID;
trainsize=30;      % number of training images per category
testsize=100;
patchsize=16;      % patch size
constantSize=200;  % normalized images as the same size
gridspacing=8; 
image_sift='.\sift';

%% extract sift features
mkdir(image_sift);
D=dir(img_file);
for i=3:length(D)
    file_fold=[img_file '\' D(i).name];
    ims=dir([file_fold '\*.bmp']);
    sift_fold=[image_sift '\' D(i).name];
    mkdir(sift_fold);
    for j=1:length(ims)
        I=imread([file_fold '\' ims(j).name]);
        if (size(I,3)==3)
            I=rgb2gray(I);
        end;
        I=imresize(I,constantSize/sqrt(size(I,1)*size(I,2)));
        [sift_x, pos_x, pos_y]=dense_sift(I,patchsize,gridspacing);
        x=reshape(sift_x,size(sift_x,1)*size(sift_x,2),size(sift_x,3));
        save ([sift_fold '\' ims(j).name(1:end-4)], 'x');
    end;
end;
