clear all;
close all;

%% set path for logistic regression model package
addpath('./Logistic Regression Model');

%% remove existing filefolds
if exist('./document','dir')
    rmdir('./document','s');
end;
if exist('./output','dir')
    rmdir('./output','s');
end;
if exist('./working','dir')
    rmdir('./working','s');
end;
if exist('./test_working','dir')
    rmdir('./test_working','s');
end;
if exist('./score','dir')
    rmdir('./score','s');
end;

if exist('./trainImage','dir')
    rmdir('./trainImage','s');
end;

if exist('./testImage','dir')
    rmdir('./testImage','s');
end;

%% mex-C compilation
mex mexc_ComputeMAX1.cpp
mex mexc_ComputeSUM2.cpp
mex mexc_Histogram.cpp	        % pool histogram from negative images
mex mexc_LocalNormalize.cpp	    % local normalization of type single (float)
mex mexc_SharedSketch.cpp	    % learning by shared sketch algorithm (with data weights)
mex mexc_ComputeMAX2.cpp
mex mexc_ComputeMAX2MP.cpp
mex mexc_TemplateAffineTransform.cpp
mex mexc_CropInstance.cpp

%% parameters for the whole system
disp(['===============> Getting parameters, mex-c code, and training images']);
mkdir('working');               % working directory to store .mat files
mkdir('output');                % directory that contains output from the code
all_S_fold='./score';           % score fold
mkdir(all_S_fold);
img_fold='./image';             % image fold that includes both training and testing images
img_format='*.bmp';             % image format for reading
trainsize=30;                   % number of training images per category
testsize=100;                    % number of testing images per category
RandomSplit;                    % split images as training and testing examples
save('paraImg.mat','img_fold','img_format','trainsize','testsize','trainI_fold','testI_fold','all_S_fold','trainID','testID');
ParameterSettings;

%% learning codebooks from training images
TrainingProcess;

%% test the learned codebooks on image classification tasks
TestingProcess;

%% classification
ImageClassification;

%% show codebooks, sketches and classification accuracy
GenerateHtml;

%% Zip project
ZIPproject;