function imgCell = read_images_test(config, net)
% reading the test image sets. the same as read_images, but the input
% folder name is different. 

%img_file = [config.working_folder, 'images.mat'];
files = dir([config.inPath_test '*.jpg']);

if isempty(files)
   files = dir([config.inPath_test '*.JPEG']); 
end
if isempty(files)
   files = dir([config.inPath_test '*.png']); 
end

if isempty(files)
    fprintf('error: No training images are found\n');
    keyboard;
end

numImages = 0;

%if exist(img_file, 'file')
%    load(img_file);
%    numImages = length(imgCell);
%end

if numImages ~= length(files) || config.forceLearn == true;
    imgCell = cell(1, length(files));
    for iImg = 1:length(files)
        
        img = single(imread(fullfile(config.inPath_test, files(iImg).name)));
       
        if config.is_crop == true
            h = round((size(img, 1) - config.cropped_sz)/2);
         
            w = round((size(img, 2) - config.cropped_sz)/2);
        
            cropped_img = img(h:h+config.cropped_sz-1, w:w+config.cropped_sz-1, :);
          
            img = cropped_img;
            img = imresize(img, [config.sx, config.sy]);
        elseif config.is_preprocess == true
            % do rescaling 
            h = size(img, 1);
            w = size(img, 2);
            if (h < w)
                rescaled_img = imresize(img, [config.rescale_sz, config.rescale_sz * (w/h)]);
            else
                rescaled_img = imresize(img, [config.rescale_sz * (h/w), config.rescale_sz]);
            end
            
            % do random crop
            rescale_h = size(rescaled_img, 1);
            rescale_w = size(rescaled_img, 2);
            h1 = randi(rescale_h - config.sx, 1);
            w1 = randi(rescale_w - config.sy, 1);
            cropped_img = rescaled_img(h1:h1+config.sx-1, w1:w1+config.sy-1, :);
            img = cropped_img;
        else
            img = imresize(img, [config.sx,config.sy]);
        end
        
        imgCell{iImg} = 2*(img - min(img(:)))/(max(img(:))-min(img(:)))-1 ;
    end
    %save(img_file, 'imgCell');
end