function [ train_mat_X, train_mat_y, test_mat_X, test_mat_y ] = read_svhn_mat( config )
% read the svhn dataset. 

train_mat_path = [config.inPath '/train_32x32.mat'];
test_mat_path = [config.inPath '/test_32x32.mat'];

train_matXY = load(train_mat_path);
test_matXY = load(test_mat_path);

train_mat_X_uint8 = train_matXY.X;
train_mat_y = train_matXY.y;

test_mat_X_uint8 = test_matXY.X;
test_mat_y = test_matXY.y;

% normalize the train and test mat to be -1 1
num_train = size(train_mat_X_uint8, 4);
num_test = size(test_mat_X_uint8, 4);

train_mat_X = zeros(size(train_mat_X_uint8), 'single');
test_mat_X = zeros(size(test_mat_X_uint8), 'single');
for i = 1:num_train
    img = single(train_mat_X_uint8(:,:,:,i));
    train_mat_X(:,:,:,i) = 2*(img - min(img(:)))/(max(img(:))-min(img(:)))-1;
end

for i = 1:num_test
    img = single(test_mat_X(:,:,:,i));
    test_mat_X(:,:,:,i) = 2*(img - min(img(:)))/(max(img(:))-min(img(:)))-1;
end



end

