function [syn_mat] =langevin_dynamic_z_batch_train( config, net, im, syn_mat )
% Langevin sampling of the latent factor z. 
% here, each input batch actually contains the config.z_dim number of
% sub-batches. 
res = [];
%fz = vl_simplenn(net, syn_mat, [], []);
%dydz = im - fz(end).x;
%dydz = gpuArray(single(dydz));
%dydz = 2* (dydz) ./ (1.0 + dydz.^2);
%res = vl_simplenn(net, syn_mat, dydz, res, 'conserveMemory', 1, 'cudnn', 1);

for t = 1:config.Lstep
    res = vl_nfa(net, syn_mat, im, res, ...
        'conserveMemory', 1, ...
        'cudnn', 1);
    batch_start_set = [1:config.z_dim_batch:config.BatchSize];
    for current_z_dim = 1:config.z_dim
       batch_start = batch_start_set(current_z_dim);
       batch_end = batch_start + (config.z_dim_batch-1);
       syn_mat(:, current_z_dim,:, batch_start:batch_end) = syn_mat(:, current_z_dim, :, batch_start:batch_end) + config.Delta * config.Delta /2 /config.s /config.s* res(1).dzdx(:, current_z_dim, :,  batch_start:batch_end) ...
        - config.Delta * config.Delta /2 /config.refsig /config.refsig* syn_mat(:, current_z_dim, :, batch_start:batch_end);
       syn_mat(:, current_z_dim,:, batch_start:batch_end) = syn_mat(:,current_z_dim,:,  batch_start:batch_end) + config.Delta * gpuArray(randn(size(syn_mat(:, current_z_dim,:, batch_start:batch_end)), 'single')); % change tian
    end 
    %fz_tmp = vl_simplenn(net, syn_mat, [], []);
    %dydz = im - fz_tmp(end).x;
    %dydz = 2 * dydz ./ (1.0 + dydz.^2);
    %res = vl_simplenn(net, syn_mat, dydz, res, 'conserveMemory', 1, 'cudnn', 1);
end
clear res;
%syn_mat = gather(syn_mat);

end

