function [syn_mat] =langevin_dynamic_z_separate( config, net, im, syn_mat )
% for this version, used for lion-tiger data
% for 6 tiger images, we focus on z1, for 5 lion images, we focus on z2
% syn_mat: 1*2*1*batch
res = [];
fz = vl_simplenn(net, syn_mat, [], []);
dydz = im - fz(end).x;
dydz = gpuArray(single(dydz));
res = vl_simplenn(net, syn_mat, dydz, res, 'conserveMemory', 1, 'cudnn', 1);
z_center = gpuArray(zeros(size(syn_mat), 'single'));
z_center(:,1,:,:) = gpuArray(zeros(size(syn_mat(:,1,:,:)), 'single'));
z_center(:,2,:,:) = gpuArray(ones(size(syn_mat(:,2,:,:)), 'single'));
for t = 1:config.Lstep
    % for tiger
    noise = randn(size(syn_mat), 'single');
    noise_tiger = noise(:,:,:,1:6); 
    noise_lion = noise(:,:,:,7:end);
    syn_mat(:,:,:,1:6) = syn_mat(:,:,:,1:6) + config.Delta * config.Delta /2 /config.s /config.s* res(1).dzdx(:,:,:,1:6) ...
        - config.Delta * config.Delta /2 /config.refsig /config.refsig* (syn_mat(:,:,:,1:6) - z_center(:,:,:,1:6));
    syn_mat(:,:,:,1:6) = syn_mat(:,:,:,1:6) + config.Delta * gpuArray(noise_tiger); % change tian
    syn_mat(:,:,:,7:end) = syn_mat(:,:,:,7:end) + config.Delta * config.Delta /2 /config.s /config.s* res(1).dzdx(:,:,:,7:end) ...
        - config.Delta * config.Delta /2 /config.refsig /config.refsig* (syn_mat(:,:,:,7:end) + z_center(:,:,:, 7:end));
    syn_mat(:,:,:,7:end) = syn_mat(:,:,:,7:end) + config.Delta * gpuArray(noise_lion); % change tian
    
    fz_tmp = vl_simplenn(net, syn_mat, [], []);
    dydz = im - fz_tmp(end).x;
    res = vl_simplenn(net, syn_mat, dydz, res, 'conserveMemory', 1, 'cudnn', 1);
    
end
clear res;
%syn_mat = gather(syn_mat);

end

