function [syn_mat] =langevin_dynamic_z_test( config, net, im, syn_mat )
% Langevin sampling of the latent factor z. 
% different category may starts from the different initial points.
res = [];

for t = 1:config.Lstep_test
    res = vl_nfa(net, syn_mat, im, res, ...
        'conserveMemory', 1, ...
        'cudnn', 1);
    % reconstruct
    syn_mat = syn_mat + config.Delta_test * config.Delta_test /2 /config.s /config.s* res(1).dzdx ...
           - config.Delta_test * config.Delta_test /2 /config.refsig /config.refsig* syn_mat;
    % langevin noise
   
    syn_mat = syn_mat + config.Delta_test * gpuArray(randn(size(syn_mat), 'single'));        
end
end

