function [] = draw_figures(config, syn_mat, iter, SSD, name)

[I_syn, syn_mat_norm] = convert_syns_mat(config, syn_mat);
for i = 1:size(syn_mat_norm, 4)
    imwrite(syn_mat_norm(:,:,:,i), [config.figure_folder, num2str(i, '%03d.png')]);
end
im = im2uint8(I_syn);
[imind,cm] = rgb2ind(im,256);
% save samples
if iter == 1
    imwrite(imind, cm, [config.Synfolder, 'animation', '.gif'], 'DelayTime', 0.10, 'Loopcount', inf);
else
    imwrite(imind, cm, [config.Synfolder, 'animation', '.gif'], 'WriteMode', 'append', 'DelayTime', 0.10);
end

imwrite(I_syn,[config.Synfolder, name, num2str(iter, '_%04d'), '.png']);

if ~isempty(SSD)
    figure(50);
    plot(1:iter, SSD(1:iter), 'r', 'LineWidth', 3);
    axis([min(iter, 1), iter+1, 0,  max(SSD(min(iter, 1):end)) * 1.2]);
    title('reconstruction error of Images')
    drawnow;
end

end