function [] = draw_figures_reconstruct(config, syn_mat, name)

% convert to syn_mats
space = 5;

color = 0;

for i = 1:size(syn_mat, 4)
   % syn_mat(:,:,:,i) = uint8(syn_mat(:,:,:,i));
    syn_mat(:,:,:,i) = single(syn_mat(:,:,:,i)); % in yang's version, dont have this line
    gLow = min( reshape(syn_mat(:,:,:,i), [],1));
    gHigh = max(reshape(syn_mat(:,:,:,i), [],1));
    syn_mat(:,:,:,i) = (syn_mat(:,:,:,i)-gLow) / (gHigh - gLow);
end

%mattocanvas
sx = config.sx;
sy = config.sy;
dim3 = size(syn_mat, 3);
num_syn = size(syn_mat, 4);
I_syn = zeros(config.test_nTileRow * sy + space * (config.test_nTileRow-1), ...
    config.test_nTileCol * sx + space * (config.test_nTileCol-1), dim3, 'single');
k = 1;
for j = 1:config.test_nTileRow
    for i = 1:config.test_nTileCol
        I_syn( 1+(j-1)*sy + (j-1) * space : sy+(j-1)*sy + (j-1) * space, 1+(i-1)*sx + (i-1)*space : sx+(i-1)*sx + (i-1) * space, :) = syn_mat(:,:,:,k);
        k = k+1;
        if k > num_syn
            break;
        end
    end
end

% padding the boundary
for row = 1:config.test_nTileRow
    I_syn(row * sx + (row-1) * space + 1:row * sx + (row-1) * space + space, :, :) = color;
end

for col = 1:config.test_nTileCol
    I_syn(:, col * sy + (col-1) * space + 1:col * sy + (col-1) * space + space, :) = color;
end


for i = 1:size(syn_mat, 4)
    imwrite(syn_mat(:,:,:,i), [config.test_figure_folder, num2str(i, '%03d.png')]);
end


imwrite(I_syn,[config.test_folder, name, '_reconstruct.png']);

end