function [ ] = sampler_1d( config, net_cpu, syn_mats )
% syn_mats is the cell which contains the 4D array
% 1*1*1*n_samples

net = vl_simplenn_move(net_cpu, 'gpu');
% get mean and std
syn_mat = syn_mats{1};
syn_mat_vec = syn_mat(:);
m = mean(syn_mat_vec);
s = std(syn_mat_vec);
fprintf('mean:%02d, std:%02d', m, s);

% num_Z is the points we want to visualize
num_Z = 20;
Z_norm = linspace(-3,2, num_Z);
Z(1, 1, 1, :) = Z_norm*s + m;

res_Z = vl_simplenn(net, gpuArray(Z), [], [], ...
    'conserveMemory', 1, ...
    'cudnn', 1);

syn_mat_interp = gather(res_Z(end).x);

space = 3;

color = 255;

for i = 1:size(syn_mat_interp, 4)
   % syn_mat(:,:,:,i) = uint8(syn_mat(:,:,:,i));
   % syn_mat(:,:,:,i) = single(syn_mat(:,:,:,i)); % in yang's version, dont have this line
    gLow = min( reshape(syn_mat_interp(:,:,:,i), [],1));
    gHigh = max(reshape(syn_mat_interp(:,:,:,i), [],1));
    syn_mat_interp(:,:,:,i) = (syn_mat_interp(:,:,:,i)-gLow) / (gHigh - gLow);
end


sx = config.vis_dim_x;
sy = config.vis_dim_y;
dim3 = size(syn_mat_interp, 3);
num_syn = size(syn_mat_interp, 4);
I_syn = zeros(1 * sy , ...
    num_Z * sx + space * (num_Z-1), dim3, 'single');
k = 1;
for j = 1:1
    for i = 1:num_Z
        I_syn( 1+(j-1)*sy + (j-1) * space : sy+(j-1)*sy + (j-1) * space, 1+(i-1)*sx + (i-1)*space : sx+(i-1)*sx + (i-1) * space, :) = syn_mat_interp(:,:,:,k);
        k = k+1;
        if k > num_syn
           break;
        end
    end
end



for row = 1:1
    I_syn(row * sx + (row-1) * space + 1:row * sx + (row-1) * space + space, :, :) = color;
end

for col = 1:num_Z
    I_syn(:, col * sy + (col-1) * space + 1:col * sy + (col-1) * space + space, :) = color;
end

imwrite(I_syn,[config.Synfolder,  num2str(config.nIteration, 'dense_interpolation_1d_%04d'), '.png']);


end

