function [syn_mat ] = sampler_audio( opts, config, net_cpu, iter, z, audiodb )
%Used to visulize the images generated by generator network

% set up initial z
z = randn(1,config.vis_dim_z, 1, config.nTileRow*config.nTileCol, 'single');
net = vl_simplenn_move(net_cpu, 'gpu');
fz = vl_simplenn(net, gpuArray(z), [], [], ...
    'accumulate', false, ...
    'disableDropout', true, ...
    'conserveMemory', opts.conserveMemory, ...
    'backPropDepth', opts.backPropDepth, ...
    'sync', opts.sync, ...
    'cudnn', opts.cudnn);
syn_mat = gather(fz(end).x);     
numAudios = config.nTileRow * config.nTileCol;
audiowrite([config.Synfolder, num2str(iter, 'synthesis_%02d.wav')], syn_mat(:,:,:,1), config.Fs);
