function [syn_mat ] = sampler_audio( opts, config, net_cpu, iter, z, audiodb )
%Used to visulize the images generated by generator network

% set up initial z
net = vl_simplenn_move(net_cpu, 'gpu');
fz = vl_simplenn(net, gpuArray(z), [], [], ...
    'accumulate', false, ...
    'disableDropout', true, ...
    'conserveMemory', opts.conserveMemory, ...
    'backPropDepth', opts.backPropDepth, ...
    'sync', opts.sync, ...
    'cudnn', opts.cudnn);
syn_mat = gather(fz(end).x);

numAudios = config.nTileRow * config.nTileCol;
info = audioinfo([config.inPath, 'training.wav']);
t = 0:seconds(1/config.Fs):seconds(info.Duration);
t = t(1:end-1);
t_syn = 0:seconds(1/config.Fs):seconds(info.Duration*config.extend_factor);
t_syn = t_syn(1:end-1);
index = 1;
subplot(config.nTileRow+2, config.nTileCol, index);
training_signal1 = single(zeros(1, config.extend_factor*size(audiodb.audios.data, 2)));
training_signal2 = single(zeros(1, config.extend_factor*size(audiodb.audios.data, 2)));
training_signal1(1:60000) = audiodb.audios.data(:,:,:,1);
%training_signal(60001:end) = audiodb.audios.data(:,:,:,2);
plot(t_syn, training_signal1);
xlabel('Time');
ylabel('Training Signal1');
index = 2;
subplot(config.nTileRow+2, config.nTileCol, index);
training_signal2(1:60000) = audiodb.audios.data(:,:,:,2);
plot(t_syn, training_signal2);
xlabel('Time');
ylabel('Training Signal2');

i_syn = 1;
for iRow = 1:config.nTileRow
    for iCol = 1:config.nTileCol
       %audiowrite([config.Synfolder, num2str(iter, 'synthesis_%02d.wav')], syn_mat(:,:,:,iAudio), config.Fs);
       %info = audioinfo([config.Synfolder, num2str(iter, 'synthesis_%02d.wav')]);
       %t = 0:seconds(1/config.Fs):seconds(info.Duration);
       %t = t(1:end-1);
       
       index = index + 1;
       subplot(config.nTileRow+2, config.nTileCol, index);
       plot(t_syn, syn_mat(:,:,:,i_syn));
       i_syn = i_syn + 1;
       xlabel('Time');
       ylabel('Audio Signal');
       saveas(gcf, fullfile(config.Synfolder, num2str(iter, 'synthesis_%02d.png')));
       %audiowrite([config.Synfolder, num2str(iter, 'synthesis_%02d.wav')], syn_mat(:,:,:,index-1), config.Fs);
    end
end

if iter == config.nIteration
    for iAudio = 1:numAudios
       audiowrite([config.Synfolder, num2str(iAudio, 'synthesis_%02d.wav')], syn_mat(:,:,:,iAudio), config.Fs)
    end
end
