% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ARI}
\alias{ARI}
\title{ARI cluster and ARI noise}
\usage{
ARI(assignV, k0, assignT1)
}
\arguments{
\item{assignV}{a numberic vector of estimated
cluster assignments.}

\item{k0}{an integer. Cluster size cut off.
All clusters below or equal to the cut off are considered noise.}

\item{assignT1}{a numeric vector of true cluster
assignments. Noise should be assigned to small or singleton clusters.}
}
\value{
a vector of ARI cluster and ARI noise scores (ARI cluster, ARI noise).
}
\description{
Computes Adjusted Rand Index for clusters and
for noise for an estimated partition given
a true partition.
}
\examples{
# simulate a dataset
sim <- simclust(K=10, p=20, ncl=400, noise=200, overnk=0, hcube=c(-5, 5), random=TRUE)

# cluster using k-means
fitkm <- kmeans(x=sim$y, centers=10)
# cluster using solution path clustering
fitspc <- spc(y=sim$y, omega=0.5, out=FALSE)

# compute ARI cluster and ARI noise scores for the k-means partition
# and solution 4 of solution path clustering
ari_kmeans <- ARI(assignV=fitkm$cluster, k0=3, assignT1=sim$assignT1)
ari_spc <- ARI(assignV=fitspc$assignV[[4]], k0=3, assignT1=sim$assignT1)
}
\references{
Marchetti, Y., Zhou, Q. Solution path clustering with adaptive concave penalty.
Electron. J. Statist. 8 (2014), no. 1, 1569--1603.
}

