% Generated by roxygen2 (4.0.2): do not edit by hand
\name{clustsel}
\alias{clustsel}
\title{Cluster selection}
\usage{
clustsel(ytrain, class, use, classall, Beta, eta, Sy, k0)
}
\arguments{
\item{ytrain}{a numeric matrix of training data, a
subsample of the full data y.}

\item{class}{a numeric vector of cluster assignments for
the given training data. The length of the vector should be
nrow(ytrain).}

\item{use}{a numeric vector of indices for the training data.
Indices represent the position of each training data point
in the full data y.}

\item{classall}{a numeric vector of the cluster assignements
based on the full data y. The length of the vector should be
nrow(y).}

\item{Beta}{a cut off for false discovery rate (FDR) that is
greater than 0. Recommended to be in (0.01, 0.1).}

\item{eta}{an integer in (1, p), where p is the number of
dimensions of the data. Represents the number of
dimensions with the false discovery rate smaller than Beta.}

\item{Sy}{a numeric vector representing the diagonal of the covariance
matrix of the full dataset y.}

\item{k0}{an integer representing cluster size cut off.}
}
\value{
Returns a numeric vector of cluster assignments with the
rejected clusters assigned to singleton clusters.
}
\description{
Selects clusters based on chi-square tests.
Internal function for isspc.
}

