% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sequential}
\alias{sequential}
\title{Sequential assignment}
\usage{
sequential(ytrain, ytest, use, hold, classall, trimprop, k0, Sy, my, center)
}
\arguments{
\item{ytrain}{a numeric matrix of training data.}

\item{ytest}{a numeric matrix of test data.}

\item{use}{a numeric vector of data indices for the training data.
The length of the vector should be nrow(ytrain).}

\item{hold}{a numeric vector of data indices for the test data.
The length of the vector should be nrow(ytest).}

\item{classall}{a numeric vector of cluster assignments for the
full dataset. The length of the vector should be nrow(y).}

\item{trimprop}{a proportion of a cluster size to be trimmed for
computing a trimmed mean and variance and subsequently likelihood.
In general, the higher proportions result in a larger number of
tight clusters. If trimprop = 0, no trimming is performed.
Recommended not to exceed 0.25.}

\item{k0}{an integer representing cluster size cut off.}

\item{Sy}{a numeric vector representing the diagonal of the covariance
matrix of the full dataset y.}

\item{center}{"mean" or "median". Defaults to "mean".
If "median" no trimming is done.}

\item{mu}{a numeric vector representing the overall mean of the full
dataset y.}
}
\value{
Returns a numeric vector of cluster assignments with the
test data assigned to the existing clusters or to
singleton clusters that represent noise.
}
\description{
Assigns test data to existing clusters or noise
sequentially based on likelihood ratio tests.
Internal function for isspc.
}

