% Generated by roxygen2 (4.0.2): do not edit by hand
\name{simclust}
\alias{simclust}
\title{Cluster simulation}
\usage{
simclust(K, p, ncl, noise, overnk, hcube, random = TRUE)
}
\arguments{
\item{K}{a desired number of clusters.}

\item{p}{a desired number of dimensions.}

\item{ncl}{a desired number of clustered data points.}

\item{noise}{a desired number of noisy data points.}

\item{overnk}{how many clusters should overlap. Overlapping
clusters are generated such that 15-20\% of
the data points in a pair of clusters are located within the
radiuses of both clusters.}

\item{hcube}{an interval from where the clusters centers
should be randomly generated.}

\item{random}{TRUE or an integer for a seed number. If a seed number is
specified, a vector of random seeds is generated in advance for all
simulations, including cluster centers and the data points themselves.}
}
\value{
\item{y}{ a numeric matrix of data.}
\item{assignT1}{ a numeric vector of cluster assignments. Noise represented
as singleton clusters and added at the end of the dataset.}
\item{assignT2}{ a numeric vector of assignements to either clusters or noise.
1 -- for clustered data points, 2 -- for noise.}
\item{osd}{ variance used to generate the clusters, equal for all clusters.}
}
\description{
Simulate spherical, equal variance clusters with or without
noise and overlap.
}
\examples{
# simulate clusters in two dimensions, with 10\% noise and no overlap,
# set the random seed
K <- 3
p <- 2
ncl <- 300
noise <- 30
sim <- simclust(K=K, p=p, ncl=ncl, noise=noise, overnk=0, hcube=c(-5, 5), random=4787)

# scatter plot of the resulting simulated clusters,
plot(sim$y, col=c(sim$assignT1[1:ncl], rep(8, noise)), pch=c(rep(1, ncl), rep(4, noise)))

# same clusters but with overlap
sim <- simclust(K=K, p=p, ncl=ncl, noise=noise, overnk=1, hcube=c(-5, 5), random=4787)
plot(sim$y, col=c(sim$assignT1[1:ncl], rep(8, noise)), pch=c(rep(1, ncl), rep(4, noise)))
}
\references{
Marchetti, Y., Zhou, Q. Solution path clustering with adaptive concave penalty.
Electron. J. Statist. 8 (2014), no. 1, 1569--1603.
}

