% Generated by roxygen2 (4.0.2): do not edit by hand
\name{solsel}
\alias{solsel}
\title{Solution selection}
\usage{
solsel(y, assignV, a = 0.05)
}
\arguments{
\item{y}{a numeric matrix of data.}

\item{assignV}{a list of numeric vectors of cluster
assignments for a solution path.}

\item{a}{value in [0, 1] for the difference ratio cut off.
Defaults to 0.05. Recommended at (0.05, 0.1).}
}
\value{
\item{bestsol}{ the number of the best solution
selected from a solution path.}
\item{bestK}{ the estimated number of cluster selected.}
\item{diffratio}{a vector of difference ratios.}
}
\description{
Solution selection
}
\examples{
# simulated a dataset with 10 well-separated clusters
sim <- simclust(K=10, p=20, ncl=400, noise=0, overnk=0, hcube=c(-5, 5), random=5248)

# cluster with solution path clustering
fitspc <- spc(y=sim$y, omega=0.5, out=FALSE)

# select a solution and compute ARI scores for the selected solution
ss <- solsel(y=sim$y, assignV=fitspc$assignV, a=0.05)
ARI(assignV=fitspc$assignV[[ss$bestsol]], k0=3, assignT1=sim$assignT1)
}
\references{
Marchetti, Y., Zhou, Q. Solution path clustering with adaptive concave penalty.
Electron. J. Statist. 8 (2014), no. 1, 1569--1603.
}

