% Generated by roxygen2 (4.0.2): do not edit by hand
\name{spc}
\alias{spc}
\title{Solution path clustering with adaptive concave penalty}
\usage{
spc(y, omega, phi = 0.5, tau = "default", alpha = 0.9, H = "default",
  xi = 1e-04, k0 = 3, out = TRUE)
}
\arguments{
\item{y}{a numeric matrix of data with rows
representing data points and columns representing
dimensions.}

\item{omega}{an approximate proportion of
nearest neighbors that are expected to merge
in the initial solution. The value is in (0, 1).}

\item{phi}{a constant in (0, 1). Defaults to 0.5.
Represents minimization step size parameter, which is
an approximation of proportion of a distance between
nearest neighbors.}

\item{tau}{a value in (0, omega). Defaults to 0.9*omega. Is
used to compute the value of lambda, the regularization
paramter, for the initial solution.}

\item{alpha}{a constant in (0, 1). Defaults to 0.9. Represents
a proportion of the value of the concavity parameter delta for
the next iteration if a bias-variance criterion is met.}

\item{H}{a number of values of lambda to be generated. Defaults
to min(20, p), where p is the number of dimensions.}

\item{xi}{a small constant used in calculating a stopping
criterion for each iteration. Defaults to 1e-4.}

\item{k0}{an integer for a cluster cut off size. Defaults to 3.}

\item{out}{logical. Should intermediate summary output be printed.}
}
\value{
\item{assignV}{ a list of cluster assignments for each solution.}
\item{path}{ a matrix representing a summary solution path. Each
column represents delta, lambda, total number of clusters, clusters after
some cut off size, number of iterations, time in seconds, respectively.}
\item{tuniV}{ a list of matrices with cluster centers for each solution.}
}
\description{
Performs unsupervised clustering of a given dataset
and provides a path of solutions, each solution
consisting of an estimated cluster assignments
and the number of clusters. Recommended for small
datasets.
}
\examples{
# simulate a small dataset with 10 clusters and noise
sim <- simclust(K=10, p=20, ncl=400, noise=200, overnk=0, hcube=c(-5, 5), random=8432)

# cluster using solution path clustering
fitspc <- spc(y=sim$y, omega=0.5, out=FALSE)
fitspc$path

# select a solution from the solution path
ss <- solsel(y=sim$y, assignV=fitspc$assignV, a=0.05)
ARI(assignV=fitspc$assignV[[ss$bestsol]], k0=3, assignT1=sim$assignT1)

# try a different parameter omega
fitspc <- spc(y=sim$y, omega=0.1, out=FALSE)
fitspc$path
}
\references{
Marchetti, Y., Zhou, Q. Solution path clustering with adaptive concave penalty.
Electron. J. Statist. 8 (2014), no. 1, 1569--1603.
}

